//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdInterfaceInfo.hh,v 1.2 1999/05/26 11:36:59 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _CFLOWDINTERFACEINFO_HH_
#define _CFLOWDINTERFACEINFO_HH_

extern "C" {
#include "caida_t.h"
}

#include <string>
#include <map>

#include "snmp++/snmp_pp.h"

#ifndef INADDR_NONE
  #define INADDR_NONE 0xffffffff
#endif

//----------------------------------------------------------------------------
//                        class CflowdInterfaceInfo 
//----------------------------------------------------------------------------
//  This class encapsulates some interface information that can't be
//  gleaned from flow-export: the ifDescr and IP address of a Cisco
//  interface (which can be gleaned using SNMP).
//----------------------------------------------------------------------------
class CflowdInterfaceInfo
{
public:
  //--------------------------------------------------------------------------
  //                          CflowdInterfaceInfo() 
  //..........................................................................
  //  constructor
  //--------------------------------------------------------------------------
  CflowdInterfaceInfo();

  //--------------------------------------------------------------------------
  //                      ipv4addr_t IpAddress() const 
  //..........................................................................
  //  Returns the IP address in the object.  If the IP address was never
  //  set, returns INADDR_NONE.
  //--------------------------------------------------------------------------
  ipv4addr_t IpAddress() const;

  //--------------------------------------------------------------------------
  //                  ipv4addr_t IpAddress(const Oid & oid) 
  //..........................................................................
  //  Sets and returns the IP address of the interface, using an Oid
  //  that was received by asking for ipAdEntIfIndex via SNMP.
  //--------------------------------------------------------------------------
  ipv4addr_t IpAddress(const Oid & oid);

  //--------------------------------------------------------------------------
  //                     const string & IfDescr() const 
  //..........................................................................
  //  Returns the ifDescr in the object.  If this was never set, returns
  //  an empty string (i.e. string("")).
  //--------------------------------------------------------------------------
  const string & IfDescr() const;

  //--------------------------------------------------------------------------
  //               const string & IfDescr(const char * descr) 
  //..........................................................................
  //  Sets and returns the ifDescr in the object.
  //--------------------------------------------------------------------------
  const string & IfDescr(const char * descr);
  
private:
  ipv4addr_t  _ipAddr;
  string      _ifDescr;
};

#endif  // _CFLOWDINTERFACEINFO_HH_
