//===========================================================================
//  $Name: cflowd-2-1-b1 $
//  $Id: CflowdTableRequest.hh,v 1.3 1998/09/21 20:02:51 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _CFLOWDTABLEREQUEST_HH_
#define _CFLOWDTABLEREQUEST_HH_

#include "CflowdCisco.hh"

//---------------------------------------------------------------------------
//  class CflowdTableRequest
//---------------------------------------------------------------------------
//  This class is used by clients of cflowd on the local host.  It
//  abstracts a request for one of the tables being held in cflowd.
//---------------------------------------------------------------------------
class CflowdTableRequest
{
public:
  //-------------------------------------------------------------------------
  //                       inline CflowdTableRequest()                       
  //.........................................................................
  //  constructor
  //-------------------------------------------------------------------------
  inline CflowdTableRequest()
  {
    this->_routerIpAddr = 0;
    this->_tableIndex = 0;
  }
  
  //-------------------------------------------------------------------------
  //                  inline ipv4addr_t RouterIpAddr() const                 
  //.........................................................................
  //  Returns the IP address of the router for which the table request
  //  was made.
  //-------------------------------------------------------------------------
  inline ipv4addr_t RouterIpAddr() const
  {
    return(this->_routerIpAddr);
  }
  
  //-------------------------------------------------------------------------
  //         inline ipv4addr_t RouterIpAddr(ipv4addr_t routerIpAddr)         
  //.........................................................................
  //  Sets and returns the IP address of the router for which the table
  //  request will be made.
  //-------------------------------------------------------------------------
  inline ipv4addr_t RouterIpAddr(ipv4addr_t routerIpAddr)
  {
    this->_routerIpAddr = routerIpAddr;
    return(this->_routerIpAddr);
  }
  
  //-------------------------------------------------------------------------
  //                    inline uint16_t TableIndex() const                   
  //.........................................................................
  //  Returns the table index of the request.  Normally this will only
  //  have a single bit set, indicating a single table is being
  //  retrieved.  However, it may have multiple bits set, in which case
  //  cflowd will respond with multiple tables.
  //-------------------------------------------------------------------------
  inline uint16_t TableIndex() const
  {
    return(this->_tableIndex);
  }
  
  //-------------------------------------------------------------------------
  //             inline uint16_t TableIndex(uint16_t tableIndex)             
  //.........................................................................
  //  Sets and returns the table index of the request.  Normally only a
  //  single bit of the index will be set, indicating a single table is
  //  to be retrieved.  However, it may have multiple bits set, in which case
  //  cflowd will respond with multiple tables.
  //-------------------------------------------------------------------------
  inline uint16_t TableIndex(uint16_t tableIndex)
  {
    this->_tableIndex = tableIndex;
    return(this->_tableIndex);
  }
  
  //-------------------------------------------------------------------------
  //                            int Read(int fd)
  //.........................................................................
  //  Reads a table request from a file descriptor.  Returns the number
  //  of bytes read on success, -1 on failure.
  //-------------------------------------------------------------------------
  int Read(int fd);
  
  //-------------------------------------------------------------------------
  //                         int Write(int fd) const
  //.........................................................................
  //  Writes a table request to a file descriptor.  Returns the number
  //  of bytes written on success, -1 on failure.
  //-------------------------------------------------------------------------
  int Write(int fd) const;
  
private:
  ipv4addr_t  _routerIpAddr;
  uint16_t    _tableIndex;
};

#endif  // _CFLOWDTABLEREQUEST_HH_
