//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdTosTable.hh,v 1.1 1999/04/30 20:02:15 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _CFLOWDTOSTABLE_HH_
#define _CFLOWDTOSTABLE_HH_

extern "C" {
#include <sys/types.h>
#include <unistd.h>
  
#include "caida_t.h"
}

#include <map>

#include "ArtsPrimitive.hh"
#include "CflowdTosTableTrafficCounter.hh"
#include "CflowdRawFlow.hh"

typedef map<uint8_t,CflowdTosTableTrafficCounter,less<uint8_t> > _CflowdTosTableMap_t;

//---------------------------------------------------------------------------
//  class CflowdTosTable : public _CflowdTosTableMap_t
//---------------------------------------------------------------------------
//  This class is used to contain TOS traffic data in cflowd++.
//  We use the TOS value as a key, and a CflowdTosTableTrafficCounter
//  to hold data in an STL map.
//  Note we just inherit from an instantiation of an STL map, then just
//  add some new member functions.
//---------------------------------------------------------------------------
class CflowdTosTable : public _CflowdTosTableMap_t
{
public:
  typedef _CflowdTosTableMap_t::iterator         iterator;
  typedef _CflowdTosTableMap_t::const_iterator   const_iterator;
  
  //-------------------------------------------------------------------------
  //                  int AddFlow(const CflowdRawFlow & flow)
  //.........................................................................
  //  Adds data to the TOS table from the flows in flowpdu.
  //  Returns the number of flows handled.
  //-------------------------------------------------------------------------
  int AddFlow(const CflowdRawFlow & flow);
  
  //-------------------------------------------------------------------------
  //                      istream & read(istream & is)
  //.........................................................................
  //  Reads the TOS data from an istream.  Returns the istream.
  //-------------------------------------------------------------------------
  istream & read(istream & is);
  
  //-------------------------------------------------------------------------
  //                            int read(int fd)
  //.........................................................................
  //  Reads the TOS data from a file descriptor.  Returns the
  //  number of bytes read on success, -1 on failure.
  //-------------------------------------------------------------------------
  int read(int fd);
  
  //-------------------------------------------------------------------------
  //                   ostream & write(ostream & os) const
  //.........................................................................
  //  Writes the TOS data to an ostream.  Returns the ostream.
  //-------------------------------------------------------------------------
  ostream & write(ostream & os) const;
  
  //-------------------------------------------------------------------------
  //                         int write(int fd) const
  //.........................................................................
  //  Writes the TOS data to a file descriptor.  Returns the
  //  number of bytes written on success, -1 on failure.
  //-------------------------------------------------------------------------
  int write(int fd) const;

//-------------------------------------------------------------------------
// friend ostream& operator << (ostream& os,                
//                              const CflowdTosTable & tosTable)
//.........................................................................
//  
//-------------------------------------------------------------------------
  friend ostream& operator << (ostream& os,
                               const CflowdTosTable & tosTable);
  
};

#endif  // _CFLOWDTOSTABLE_HH_
