//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: Signal.hh,v 1.1 1998/09/14 17:07:32 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, skitter, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, skitter, is developed by Daniel W. McRobb,
//  and copyrighted (C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for skitter software. You can
//  redistribute it and/or modify it under the terms of the GNU General
//  Public License, v.  2 dated June 1991 which is incorporated by
//  reference herein.  skitter is distributed WITHOUT ANY
//  WARRANTY, IMPLIED OR EXPRESS, OF MERCHANTABILITY OR FITNESS FOR A
//  PARTICULAR PURPOSE or that the use of it will not infringe on any
//  third party's intellectual property rights.
//
//  You should have received a copy of the GNU GPL along with the skitter
//  package.  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _SIGNAL_HH_
#define _SIGNAL_HH_
#include <deque>

extern "C" {
#include <signal.h>
}

typedef struct sigaction sigactStruct;

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//                             class Signal
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//  Abstracts a UNIX signal.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class Signal
{
public:
  //-------------------------------------------------------------------------
  //                           Signal(int sigNum)                           
  //.........................................................................
  //  Constructor accepting a signal number (SIGHUP, SIGALRM, etc.).
  //-------------------------------------------------------------------------
  Signal(int sigNum);

  //-------------------------------------------------------------------------
  //                               int Block()                              
  //.........................................................................
  //  Block the signal.
  //-------------------------------------------------------------------------
  int Block();
  
  //-------------------------------------------------------------------------
  //                             int IsBlocked()                         
  //.........................................................................
  //  Returns 1 if signal is currently being blocked, else returns 0.
  //-------------------------------------------------------------------------
  int IsBlocked();
  
  //-------------------------------------------------------------------------
  //                              int Unblock()                             
  //.........................................................................
  //  Unblocks the signal.
  //-------------------------------------------------------------------------
  int Unblock();
  
  //-------------------------------------------------------------------------
  //                             int IsPending()                            
  //.........................................................................
  //  Returns 1 if the signal is pending (and blocked), else returns 0.
  //-------------------------------------------------------------------------
  int IsPending();
  
  //-------------------------------------------------------------------------
  //                int InstallHandler(void (*handler)(int))                
  //.........................................................................
  //  Installs 'handler' as signal handler for the signal.  Note that this
  //  class implements a stack of handlers, so you can push handlers onto
  //  the stack up to any depth.
  //-------------------------------------------------------------------------
  int InstallHandler(void (*handler)(int));

  //-------------------------------------------------------------------------
  //                           int RemoveHandler()                          
  //.........................................................................
  //  Removes the last installed signal handler for the signal.
  //-------------------------------------------------------------------------
  int RemoveHandler();
  
  //-------------------------------------------------------------------------
  //                              int Caught()                              
  //.........................................................................
  //  Returns 1 if the signal was caught, else returns 0.
  //-------------------------------------------------------------------------
  int Caught();
  
  //-------------------------------------------------------------------------
  //                              void Catch()                              
  //.........................................................................
  //  Resets the 'caught' state of the signal.  This is typically used after
  //  the class user has noted that the signal was caught (using Caught()).
  //-------------------------------------------------------------------------
  void Catch();
  
private:
  sigset_t             caughtSignals;
  int                  signalNumber;
  deque<sigactStruct>  sigactionStack;
};

#endif  //  _SIGNAL_HH_
