//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdAsMatrix.cc,v 1.16 1999/02/19 02:20:04 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#include <string>
#include <strstream.h>

#include "ArtsPrimitive.hh"
#include "CflowdAsMatrix.hh"

#define k_flowAsMatrixFieldsMask  (CflowdRawFlow::k_srcAsMask|\
                                   CflowdRawFlow::k_dstAsMask|\
                                   CflowdRawFlow::k_pktsMask|\
                                   CflowdRawFlow::k_bytesMask)

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdAsMatrix.cc,v 1.16 1999/02/19 02:20:04 dwm Exp $";

ArtsPrimitive g_CfdArtsPrimitive;

//-------------------------------------------------------------------------
//         int CflowdAsMatrix::AddFlow(const CflowdRawFlow & flow)
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdAsMatrix::AddFlow(const CflowdRawFlow & flow)
{
  CflowdAsMatrixKey  asmKey;

  if ((flow.Index() & k_flowAsMatrixFieldsMask) == k_flowAsMatrixFieldsMask) {
    asmKey.Src(flow.SrcAs());
    asmKey.Dst(flow.DstAs());
    ((*this)[asmKey]).AddPkts(flow.Pkts());
    ((*this)[asmKey]).AddBytes(flow.Bytes());
    return(0);
  }
  else {
    if (flow.Version() != 8) {
      syslog(LOG_ERR,
             "[E] got a v%d flow without AS matrix fields"
             " (index = %#x) {%s:%d}",
             flow.Version(),flow.Index(),__FILE__,__LINE__);
    }
  }
  
  return(-1);
}

//-------------------------------------------------------------------------
//               istream & CflowdAsMatrix::read(istream & is)              
//.........................................................................
//  
//-------------------------------------------------------------------------
istream & CflowdAsMatrix::read(istream & is)
{
  uint64_t                      numEntries, entryNum;
  CflowdAsMatrixKey             asKey;
  CflowdAsMatrixTrafficCounter  asTraffic;

  if (! (*this).empty()) {
    (*this).erase((*this).begin(),(*this).end());
  }
  
  g_CfdArtsPrimitive.ReadUint64(is,numEntries,sizeof(numEntries));
  for (entryNum = 0; entryNum < numEntries; entryNum++) {
    asKey.read(is);
    asTraffic.read(is);
    (*this)[asKey] = asTraffic;
  }
  return(is);
}

//-------------------------------------------------------------------------
//                     int CflowdAsMatrix::read(int fd)                    
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdAsMatrix::read(int fd)
{
  uint64_t                      numEntries, entryNum;
  CflowdAsMatrixKey             asKey;
  CflowdAsMatrixTrafficCounter  asTraffic;
  int                           rc;
  int                           bytesRead = 0;

  if (! (*this).empty()) {
    (*this).erase((*this).begin(),(*this).end());
  }
  
  rc = g_CfdArtsPrimitive.ReadUint64(fd,numEntries,sizeof(numEntries));
  if (rc < (int)sizeof(numEntries)) {
    syslog(LOG_ERR,
           "[E] ReadUint64(%d,%d,%d) failed (rc = %d):"
           " %m {%s:%d}",
           fd,numEntries,sizeof(numEntries),rc,__FILE__,__LINE__);
    return(-1);
  }
  bytesRead += rc;

  uint32_t expectedLength =
    numEntries * (CflowdAsMatrixKey::Length() + 
                  CflowdAsMatrixTrafficCounter::Length());
  char buf[expectedLength];
  
  if (g_CfdArtsPrimitive.FdRead(fd,buf,expectedLength) < expectedLength) {
    syslog(LOG_ERR,"[E] ArtsPrimitive.FdRead(%d,%p,%u) failed: %m {%s:%d}",
           fd,buf,expectedLength,__FILE__,__LINE__);
    return(-1);
  }

  istrstream  inStream(buf,expectedLength);
  
  for (entryNum = 0; entryNum < numEntries; entryNum++) {
    asKey.read(inStream);
    asTraffic.read(inStream);
    (*this)[asKey] = asTraffic;
  }
  bytesRead += expectedLength;
  
  return(bytesRead);
}

//-------------------------------------------------------------------------
//           ostream & CflowdAsMatrix::write(ostream & os) const           
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream & CflowdAsMatrix::write(ostream & os) const
{
  uint64_t                        numEntries;
  CflowdAsMatrix::const_iterator  asmIter;
  
  numEntries = (*this).size();
  
  g_CfdArtsPrimitive.WriteUint64(os,numEntries,sizeof(numEntries));

  for (asmIter = (*this).begin(); asmIter != (*this).end(); asmIter++) {
    (*asmIter).first.write(os);
    (*asmIter).second.write(os);
  }
  return(os);
}

//-------------------------------------------------------------------------
//                 int CflowdAsMatrix::write(int fd) const                 
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdAsMatrix::write(int fd) const
{
  uint64_t                        numEntries;
  CflowdAsMatrix::const_iterator  asmIter;
  int                             rc;
  int                             bytesWritten = 0;
  
  numEntries = (*this).size();
  rc = g_CfdArtsPrimitive.WriteUint64(fd,numEntries,sizeof(numEntries));
  if (rc < (int)sizeof(numEntries)) {
    syslog(LOG_ERR,
           "[E] ArtsPrimitive.WriteUint64(%d,%d,%d) failed: %m {%s:%d}",
           fd,numEntries,sizeof(numEntries),__FILE__,__LINE__);
    return(-1);
  }
  bytesWritten += rc;
  for (asmIter = (*this).begin(); asmIter != (*this).end(); asmIter++) {
    rc = (*asmIter).first.write(fd);
    if (rc < 0) {
      return(-1);
    }
    bytesWritten += rc;
    rc = (*asmIter).second.write(fd);
    if (rc < 0) {
      return(-1);
    }
    bytesWritten += rc;
  }
  return(bytesWritten);
}


uint8_t CflowdUint16Uint16Key::_ioLength = sizeof(uint16_t) * 2;
