//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdCiscoFlowEngine.cc,v 1.4 1999/02/18 08:04:41 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

extern "C" {
#include "caida_t.h"
}

#include <string>

#include "CflowdCiscoFlowEngine.hh"

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdCiscoFlowEngine.cc,v 1.4 1999/02/18 08:04:41 dwm Exp $";

//-------------------------------------------------------------------------
//   uint32_t CflowdCiscoFlowEngine::SequenceNumber(uint32_t seqNumber,   
//                                                  uint16_t flowCount,
//                                                  uint8_t aggMethod = 0)   
//.........................................................................
//  
//-------------------------------------------------------------------------
uint32_t CflowdCiscoFlowEngine::SequenceNumber(uint32_t seqNumber,
                                               uint16_t flowCount,
                                               uint8_t aggMethod = 0)
{
  if (aggMethod > k_CiscoV8FlowExportMaxAggType) {
    syslog(LOG_ERR,
           "[E] CflowdCiscoFlowEngine::SequenceNumber() called with bogus"
           " aggMethod (%u) {%s:%d}",aggMethod,__FILE__,__LINE__);
    return(0);
  }
           
  if (this->_seqNumber[aggMethod] != 0) {
    if (this->_seqNumber[aggMethod] < seqNumber) {
      //  we either missed some flows or got them out of order (early).
      this->_missedFlows[aggMethod] +=
        (seqNumber - this->_seqNumber[aggMethod]);
    }
    else {
      if (this->_seqNumber[aggMethod] > seqNumber) {
        //  we got some flows out of order (late).
        if (this->_missedFlows[aggMethod] >= flowCount)
          this->_missedFlows[aggMethod] -= flowCount;
      }
    }
  }
  if (seqNumber + flowCount > this->_seqNumber[aggMethod])
    this->_seqNumber[aggMethod] = seqNumber + flowCount;
  this->_flowsReceived[aggMethod] += flowCount;
  
  return(this->_seqNumber[aggMethod]);
}
