//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdInterfaceInfo.cc,v 1.1 1999/05/25 09:07:18 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

extern "C" {
  
}

#include <string>

#include "CflowdInterfaceInfo.hh"

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdInterfaceInfo.cc,v 1.1 1999/05/25 09:07:18 dwm Exp $";

//----------------------------------------------------------------------------
//              CflowdInterfaceInfo::CflowdInterfaceInfo() 
//............................................................................
//  
//----------------------------------------------------------------------------
CflowdInterfaceInfo::CflowdInterfaceInfo()
{
  this->_ifDescr = string("");
  this->_ipAddr = INADDR_NONE;
}

//----------------------------------------------------------------------------
//           ipv4addr_t CflowdInterfaceInfo::IpAddress() const 
//............................................................................
//  
//----------------------------------------------------------------------------
ipv4addr_t CflowdInterfaceInfo::IpAddress() const
{
  return(this->_ipAddr);
}

//----------------------------------------------------------------------------
//       ipv4addr_t CflowdInterfaceInfo::IpAddress(const Oid & oid) 
//............................................................................
//  
//----------------------------------------------------------------------------
ipv4addr_t CflowdInterfaceInfo::IpAddress(const Oid & oid)
{
  this->_ipAddr = 0;
  
  for (int i = oid.len() - 4; i < oid.len(); i++) {
    this->_ipAddr |= ((ipv4addr_t)(oid[i]) << ((oid.len() - (i + 1)) * 8));
  }

  this->_ipAddr = htonl(this->_ipAddr);
  
  return(this->_ipAddr);
}

//----------------------------------------------------------------------------
//           const string & CflowdInterfaceInfo::IfDescr() const 
//............................................................................
//  
//----------------------------------------------------------------------------
const string & CflowdInterfaceInfo::IfDescr() const
{
  return(this->_ifDescr);
}

//----------------------------------------------------------------------------
//    const string & CflowdInterfaceInfo::IfDescr(const char * ifDescr) 
//............................................................................
//  
//----------------------------------------------------------------------------
const string & CflowdInterfaceInfo::IfDescr(const char * ifDescr)
{
  this->_ifDescr = string(ifDescr);
  return(this->_ifDescr);
}
