//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdInterfaceMatrix.cc,v 1.5 1998/12/11 10:17:50 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#include <string>

#include "ArtsPrimitive.hh"
#include "CflowdInterfaceMatrix.hh"

#define k_flowInterfaceMatrixFieldsMask (CflowdRawFlow::k_inputIfIndexMask|\
                                         CflowdRawFlow::k_outputIfIndexMask|\
                                         CflowdRawFlow::k_pktsMask|\
                                         CflowdRawFlow::k_bytesMask)

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdInterfaceMatrix.cc,v 1.5 1998/12/11 10:17:50 dwm Exp $";

//-------------------------------------------------------------------------
//     int CflowdInterfaceMatrix::AddFlow(const CflowdRawFlow & flow)
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdInterfaceMatrix::AddFlow(const CflowdRawFlow & flow)
{
  CflowdInterfaceMatrixKey  intfmKey;

  if ((flow.Index() & k_flowInterfaceMatrixFieldsMask) ==
      k_flowInterfaceMatrixFieldsMask) {
    intfmKey.Src(flow.InputIfIndex());
    intfmKey.Dst(flow.OutputIfIndex());
    ((*this)[intfmKey]).AddPkts(flow.Pkts());
    ((*this)[intfmKey]).AddBytes(flow.Bytes());
    return(0);
  }

  return(-1);
}

//-------------------------------------------------------------------------
//           istream & CflowdInterfaceMatrix::read(istream & is)
//.........................................................................
//  
//-------------------------------------------------------------------------
istream & CflowdInterfaceMatrix::read(istream & is)
{
  uint64_t                             numEntries, entryNum;
  CflowdInterfaceMatrixKey             intfKey;
  CflowdInterfaceMatrixTrafficCounter  intfTraffic;

  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }
  
  g_CfdArtsPrimitive.ReadUint64(is,numEntries,sizeof(numEntries));
  for (entryNum = 0; entryNum < numEntries; entryNum++) {
    intfKey.read(is);
    intfTraffic.read(is);
    (*this)[intfKey] = intfTraffic;
  }
  return(is);
}

//-------------------------------------------------------------------------
//                 int CflowdInterfaceMatrix::read(int fd)
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdInterfaceMatrix::read(int fd)
{
  uint64_t                             numEntries, entryNum;
  CflowdInterfaceMatrixKey             intfKey;
  CflowdInterfaceMatrixTrafficCounter  intfTraffic;
  int                                  rc;
  int                                  bytesRead = 0;

  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }
  
  rc = g_CfdArtsPrimitive.ReadUint64(fd,numEntries,sizeof(numEntries));
  if (rc < (int)sizeof(numEntries)) {
    return(-1);
  }
  bytesRead += rc;
  
  for (entryNum = 0; entryNum < numEntries; entryNum++) {
    rc = intfKey.read(fd);
    if (rc < 0) {
      return(-1);
    }
    bytesRead += rc;
    rc = intfTraffic.read(fd);
    if (rc < 0) {
      return(-1);
    }
    bytesRead += rc;
    (*this)[intfKey] = intfTraffic;
  }
  return(bytesRead);
}

//-------------------------------------------------------------------------
//      ostream & CflowdInterfaceMatrix::write(ostream & os) const
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream & CflowdInterfaceMatrix::write(ostream & os) const
{
  uint64_t                               numEntries;
  CflowdInterfaceMatrix::const_iterator  intfmIter;
  
  numEntries = (*this).size();
  
  g_CfdArtsPrimitive.WriteUint64(os,numEntries,sizeof(numEntries));

  for (intfmIter = (*this).begin(); intfmIter != (*this).end(); intfmIter++) {
    (*intfmIter).first.write(os);
    (*intfmIter).second.write(os);
  }
  return(os);
}

//-------------------------------------------------------------------------
//             int CflowdInterfaceMatrix::write(int fd) const
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdInterfaceMatrix::write(int fd) const
{
  uint64_t                               numEntries;
  CflowdInterfaceMatrix::const_iterator  intfmIter;
  int                                    rc;
  int                                    bytesWritten = 0;
  
  numEntries = (*this).size();
  rc = g_CfdArtsPrimitive.WriteUint64(fd,numEntries,sizeof(numEntries));
  if (rc < (int)sizeof(numEntries)) {
    return(-1);
  }
  bytesWritten += rc;
  
  for (intfmIter = (*this).begin(); intfmIter != (*this).end(); intfmIter++) {
    rc = (*intfmIter).first.write(fd);
    if (rc < 0) {
      return(-1);
    }
    bytesWritten += rc;
    rc = (*intfmIter).second.write(fd);
    if (rc < 0) {
      return(-1);
    }
    bytesWritten += rc;
  }
  return(bytesWritten);
}


