//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdNextHopTable.cc,v 1.5 1998/12/11 10:17:50 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#include <string>

#include "CflowdNextHopTable.hh"

#define k_flowNextHopTableFieldsMask (CflowdRawFlow::k_ipNextHopMask|\
                                      CflowdRawFlow::k_pktsMask|\
                                      CflowdRawFlow::k_bytesMask)

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdNextHopTable.cc,v 1.5 1998/12/11 10:17:50 dwm Exp $";

//-------------------------------------------------------------------------
//        int CflowdNextHopTable::AddFlow(const CflowdRawFlow & flow)       
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdNextHopTable::AddFlow(const CflowdRawFlow & flow)
{
  if ((flow.Index() & k_flowNextHopTableFieldsMask) ==
      k_flowNextHopTableFieldsMask) {
    ((*this)[flow.IpNextHop()]).AddPkts(flow.Pkts());
    ((*this)[flow.IpNextHop()]).AddBytes(flow.Bytes());
    return(0);
  }

  return(-1);
}

//-------------------------------------------------------------------------
//            istream & CflowdNextHopTable::read(istream & is)            
//.........................................................................
//  
//-------------------------------------------------------------------------
istream & CflowdNextHopTable::read(istream & is)
{
  uint32_t                          numNextHops;
  ipv4addr_t                        nextHopNum;
  ipv4addr_t                        nextHop;
  CflowdNextHopTableTrafficCounter  nextHopTraffic;
  
  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }

  is.read(&numNextHops,sizeof(numNextHops));
  numNextHops = ntohl(numNextHops);
  
  for (nextHopNum = 0; nextHopNum < numNextHops; nextHopNum++) {
    is.read(&nextHop,sizeof(nextHop));
    nextHopTraffic.read(is);
    (*this)[nextHop] = nextHopTraffic;
  }
  return(is);
}

//-------------------------------------------------------------------------
//                  int CflowdNextHopTable::read(int fd)                  
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdNextHopTable::read(int fd)
{
  uint32_t                           numNextHops;
  ipv4addr_t                         nextHopNum;
  ipv4addr_t                         nextHop;
  CflowdNextHopTableTrafficCounter   nextHopTraffic;
  int                                rc;
  int                                bytesRead = 0;
  
  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }

  rc = g_CfdArtsPrimitive.ReadUint32(fd,numNextHops,sizeof(numNextHops));
  if (rc < (int)sizeof(numNextHops)) {
    syslog(LOG_ERR,"[E] ReadUint32(%d,%p,%d) failed: %m {%s:%d}",
           fd,&numNextHops,sizeof(numNextHops),__FILE__,__LINE__);
    return(-1);
  }
  bytesRead += rc;
  
  for (nextHopNum = 0; nextHopNum < numNextHops; nextHopNum++) {
    rc = g_CfdArtsPrimitive.FdRead(fd,&nextHop,sizeof(nextHop));
    if (rc < (int)sizeof(nextHop)) {
      syslog(LOG_ERR,"[E] FdRead(%d,%p,%d) failed: %m {%s:%d}",
             fd,&nextHop,sizeof(nextHop),__FILE__,__LINE__);
      return(-1);
    }
    bytesRead += rc;
    
    rc = nextHopTraffic.read(fd);
    if (rc < 0) {
      syslog(LOG_ERR,"[E] nextHopTraffic.read(%d) failed: %m {%s:%d}",
             fd,__FILE__,__LINE__);
      return(-1);
    }
    bytesRead += rc;
    
    (*this)[nextHop] = nextHopTraffic;
  }
  return(bytesRead);
}

//-------------------------------------------------------------------------
//         ostream & CflowdNextHopTable::write(ostream & os) const        
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream & CflowdNextHopTable::write(ostream & os) const
{
  ipv4addr_t                          nextHop;
  uint32_t                            numNextHops;
  CflowdNextHopTable::const_iterator  nextHopIter;
  
  numNextHops = (*this).size();
  numNextHops = htonl(numNextHops);
  os.write(&numNextHops,sizeof(numNextHops));

  for (nextHopIter = (*this).begin(); nextHopIter != (*this).end();
       nextHopIter++) {
    nextHop = (*nextHopIter).first;
    os.write(&nextHop,sizeof(nextHop));
    (*nextHopIter).second.write(os);
  }
  return(os);
}

//-------------------------------------------------------------------------
//               int CflowdNextHopTable::write(int fd) const              
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdNextHopTable::write(int fd) const
{
  ipv4addr_t                           nextHop;
  uint32_t                             numNextHops;
  CflowdNextHopTable::const_iterator   nextHopIter;
  int                                  rc;
  int                                  bytesWritten = 0;
  
  numNextHops = (*this).size();
  rc = g_CfdArtsPrimitive.WriteUint32(fd,numNextHops,sizeof(numNextHops));
  if (rc < (int)sizeof(numNextHops)) {
    syslog(LOG_ERR,"[E] WriteUint32(%d,%p,%d) failed: %m {%s:%d}",
           fd,&numNextHops,sizeof(numNextHops),__FILE__,__LINE__);
    return(-1);
  }
  bytesWritten += rc;
  
  for (nextHopIter = (*this).begin(); nextHopIter != (*this).end();
       nextHopIter++) {
    nextHop = (*nextHopIter).first;
    rc = g_CfdArtsPrimitive.FdWrite(fd,&nextHop,sizeof(nextHop));
    if (rc < (int)sizeof(nextHop)) {
      syslog(LOG_ERR,"[E] FdWrite(%d,%p,%d) failed: %m {%s:%d}",
             fd,&nextHop,sizeof(nextHop),__FILE__,__LINE__);
      return(-1);
    }
    bytesWritten += rc;
    
    rc = (*nextHopIter).second.write(fd);
    if (rc < 0) {
      syslog(LOG_ERR,"[E] (*nextHopIter).second.write(%d) failed {%s:%d}",
             fd,__FILE__,__LINE__);
      return(-1);
    }
    bytesWritten += rc;
  }
  return(bytesWritten);
}

//-------------------------------------------------------------------------
//    ostream& operator << (ostream& os,                   
//                          const CflowdNextHopTable & nextHopTable) 
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream& operator << (ostream& os,
                      const CflowdNextHopTable & nextHopTable)
{
  CflowdNextHopTable::const_iterator  nextHopIter;

  for (nextHopIter = nextHopTable.begin();
       nextHopIter != nextHopTable.end(); nextHopIter++) {
    os << "NEXTHOP ENTRY" << endl
       << "  nextHop: " << (uint16_t)(*nextHopIter).first << endl
       << "   packets: " << (*nextHopIter).second.Pkts() << endl
       << "     bytes: " << (*nextHopIter).second.Bytes() << endl;
  }
  return(os);
}
