//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdPortMatrix.cc,v 1.13 1999/02/09 19:12:51 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#include <string>
#include <strstream.h>

#include "ArtsPrimitive.hh"
#include "CflowdPortMatrix.hh"

#define k_flowPortMatrixFieldsMask (CflowdRawFlow::k_srcPortMask|\
                                    CflowdRawFlow::k_dstPortMask|\
                                    CflowdRawFlow::k_pktsMask|\
                                    CflowdRawFlow::k_bytesMask)

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdPortMatrix.cc,v 1.13 1999/02/09 19:12:51 dwm Exp $";

//-------------------------------------------------------------------------
//        int CflowdPortMatrix::AddFlow(const CflowdRawFlow & flow)
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdPortMatrix::AddFlow(const CflowdRawFlow & flow)
{
  CflowdPortMatrixKey   portmKey;

  if ((flow.Index() & k_flowPortMatrixFieldsMask) ==
      k_flowPortMatrixFieldsMask) {
    if (flow.Protocol() != 6 && flow.Protocol() != 17)
      return(-1);
    portmKey.Src(flow.SrcPort());
    portmKey.Dst(flow.DstPort());
    ((*this)[portmKey]).AddPkts(flow.Pkts());
    ((*this)[portmKey]).AddBytes(flow.Bytes());
    return(0);
  }
  else {
    return(-1);
  }
}

//-------------------------------------------------------------------------
//               istream & CflowdPortMatrix::read(istream & is)              
//.........................................................................
//  
//-------------------------------------------------------------------------
istream & CflowdPortMatrix::read(istream & is)
{
  uint64_t                        numEntries, entryNum;
  CflowdPortMatrixKey             portKey;
  CflowdPortMatrixTrafficCounter  portTraffic;

  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }
  
  g_CfdArtsPrimitive.ReadUint64(is,numEntries,sizeof(numEntries));
  for (entryNum = 0; entryNum < numEntries; entryNum++) {
    portKey.read(is);
    portTraffic.read(is);
    (*this)[portKey] = portTraffic;
  }
  return(is);
}

//-------------------------------------------------------------------------
//                     int CflowdPortMatrix::read(int fd)                    
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdPortMatrix::read(int fd)
{
  uint64_t                        numEntries, entryNum;
  CflowdPortMatrixKey             portKey;
  CflowdPortMatrixTrafficCounter  portTraffic;
  int                             rc;
  int                             bytesRead = 0;

  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }
  
  rc = g_CfdArtsPrimitive.ReadUint64(fd,numEntries,sizeof(numEntries));
  if (rc < (int)sizeof(numEntries)) {
    syslog(LOG_ERR,"[E] ArtsPrimitive.ReadUint64(%d,%d,%d) failed: %m {%s:%d}",
           fd,numEntries,sizeof(numEntries),__FILE__,__LINE__);
    return(-1);
  }
  bytesRead += rc;
  
  uint32_t expectedLength =
    numEntries * (CflowdPortMatrixKey::Length() + 
                  CflowdPortMatrixTrafficCounter::Length());
  char buf[expectedLength];
  
  if (g_CfdArtsPrimitive.FdRead(fd,buf,expectedLength) < expectedLength) {
    syslog(LOG_ERR,"[E] ArtsPrimitive.FdRead(%d,%p,%u) failed: %m {%s:%d}",
           fd,buf,expectedLength,__FILE__,__LINE__);
    return(-1);
  }

  istrstream  inStream(buf,expectedLength);
  
  for (entryNum = 0; entryNum < numEntries; entryNum++) {
    portKey.read(inStream);
    portTraffic.read(inStream);
    (*this)[portKey] = portTraffic;
  }
  bytesRead += expectedLength;
  
  return(bytesRead);
}

//-------------------------------------------------------------------------
//           ostream & CflowdPortMatrix::write(ostream & os) const           
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream & CflowdPortMatrix::write(ostream & os) const
{
  uint64_t                          numEntries;
  CflowdPortMatrix::const_iterator  portmIter;
  
  numEntries = (*this).size();
  
  g_CfdArtsPrimitive.WriteUint64(os,numEntries,sizeof(numEntries));

  for (portmIter = (*this).begin(); portmIter != (*this).end(); portmIter++) {
    (*portmIter).first.write(os);
    (*portmIter).second.write(os);
  }
  return(os);
}

//-------------------------------------------------------------------------
//                 int CflowdPortMatrix::write(int fd) const                 
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdPortMatrix::write(int fd) const
{
  uint64_t                          numEntries;
  CflowdPortMatrix::const_iterator  portmIter;
  int                               rc;
  int                               bytesWritten = 0;
  
  numEntries = (*this).size();
  rc = g_CfdArtsPrimitive.WriteUint64(fd,numEntries,sizeof(numEntries));
  if (rc < (int)sizeof(numEntries)) {
    syslog(LOG_ERR,
           "[E] ArtsPrimitive.WriteUint64(%d,%d,%d) failed: %m {%s:%d}",
           fd,numEntries,sizeof(numEntries),__FILE__,__LINE__);
    return(-1);
  }
  bytesWritten += rc;
  for (portmIter = (*this).begin(); portmIter != (*this).end(); portmIter++) {
    rc = (*portmIter).first.write(fd);
    if (rc < 0) {
      return(-1);
    }
    bytesWritten += rc;
    rc = (*portmIter).second.write(fd);
    if (rc < 0) {
      return(-1);
    }
    bytesWritten += rc;
  }
  return(bytesWritten);
}


//-------------------------------------------------------------------------
// ostream & operator << (ostream & os, const CflowdPortMatrix & portMatrix) 
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream & operator << (ostream & os, const CflowdPortMatrix & portMatrix)
{
  CflowdPortMatrix::const_iterator  portIter;

  for (portIter = portMatrix.begin(); portIter != portMatrix.end();
       portIter++) {
    os << "PORT MATRIX ENTRY" << endl
       << "src port: " << (*portIter).first.Src() << endl
       << "dst port: " << (*portIter).first.Dst() << endl
       << " packets: " << (*portIter).second.Pkts() << endl
       << "   bytes: " << (*portIter).second.Bytes() << endl;
  }
  return(os);
}
