//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdProtocolTable.cc,v 1.8 1998/12/11 10:17:51 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#include <string>

#include "CflowdProtocolTable.hh"

#define k_flowProtocolTableFieldsMask (CflowdRawFlow::k_protocolMask|\
                                       CflowdRawFlow::k_pktsMask|\
                                       CflowdRawFlow::k_bytesMask)

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdProtocolTable.cc,v 1.8 1998/12/11 10:17:51 dwm Exp $";

//-------------------------------------------------------------------------
//        int CflowdProtocolTable::AddFlow(const CflowdRawFlow & flow)       
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdProtocolTable::AddFlow(const CflowdRawFlow & flow)
{
  if ((flow.Index() & k_flowProtocolTableFieldsMask) ==
      k_flowProtocolTableFieldsMask) {
    ((*this)[flow.Protocol()]).AddPkts(flow.Pkts());
    ((*this)[flow.Protocol()]).AddBytes(flow.Bytes());
    return(0);
  }

  return(-1);
}

//-------------------------------------------------------------------------
//            istream & CflowdProtocolTable::read(istream & is)            
//.........................................................................
//  
//-------------------------------------------------------------------------
istream & CflowdProtocolTable::read(istream & is)
{
  uint8_t                            numProtocols;
  uint8_t                            protocolNum;
  uint8_t                            protocol;
  CflowdProtocolTableTrafficCounter  protoTraffic;
  
  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }

  is.read(&numProtocols,sizeof(numProtocols));
  for (protocolNum = 0; protocolNum < numProtocols; protocolNum++) {
    is.read(&protocol,sizeof(protocol));
    protoTraffic.read(is);
    (*this)[protocol] = protoTraffic;
  }
  return(is);
}

//-------------------------------------------------------------------------
//                  int CflowdProtocolTable::read(int fd)                  
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdProtocolTable::read(int fd)
{
  uint8_t                            numProtocols;
  uint8_t                            protocolNum;
  uint8_t                            protocol;
  CflowdProtocolTableTrafficCounter  protoTraffic;
  int                                rc;
  int                                bytesRead = 0;
  
  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }

  rc = g_CfdArtsPrimitive.FdRead(fd,&numProtocols,sizeof(numProtocols));
  if (rc < (int)sizeof(numProtocols)) {
    syslog(LOG_ERR,"[E] FdRead(%d,%p,%d) failed: %m {%s:%d}",
           fd,&numProtocols,sizeof(numProtocols),__FILE__,__LINE__);
    return(-1);
  }
  bytesRead += rc;

  for (protocolNum = 0; protocolNum < numProtocols; protocolNum++) {
    rc = g_CfdArtsPrimitive.FdRead(fd,&protocol,sizeof(protocol));
    if (rc < (int)sizeof(protocol)) {
      syslog(LOG_ERR,"[E] FdRead(%d,%p,%d) failed: %m {%s:%d}",
             fd,&protocol,sizeof(protocol),__FILE__,__LINE__);
      return(-1);
    }
    bytesRead += rc;
    
    rc = protoTraffic.read(fd);
    if (rc < 0) {
      syslog(LOG_ERR,"[E] protoTraffic.read(%d) failed: %m {%s:%d}",
             fd,__FILE__,__LINE__);
      return(-1);
    }
    bytesRead += rc;
    
    (*this)[protocol] = protoTraffic;
  }
  return(bytesRead);
}

//-------------------------------------------------------------------------
//         ostream & CflowdProtocolTable::write(ostream & os) const        
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream & CflowdProtocolTable::write(ostream & os) const
{
  uint8_t                              protocol;
  uint8_t                              numProtocols;
  CflowdProtocolTable::const_iterator  protoIter;
  
  numProtocols = (*this).size();
  os.write(&numProtocols,sizeof(numProtocols));

  for (protoIter = (*this).begin(); protoIter != (*this).end(); protoIter++) {
    protocol = (*protoIter).first;
    os.write(&protocol,sizeof(protocol));
    (*protoIter).second.write(os);
  }
  return(os);
}

//-------------------------------------------------------------------------
//               int CflowdProtocolTable::write(int fd) const              
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdProtocolTable::write(int fd) const
{
  uint8_t                              protocol;
  uint8_t                              numProtocols;
  CflowdProtocolTable::const_iterator  protoIter;
  int                                  rc;
  int                                  bytesWritten = 0;
  
  numProtocols = (*this).size();
  rc = g_CfdArtsPrimitive.FdWrite(fd,&numProtocols,sizeof(numProtocols));
  if (rc < (int)sizeof(numProtocols)) {
    syslog(LOG_ERR,"[E] FdWrite(%d,%p,%d) failed: %m {%s:%d}",
           fd,&numProtocols,sizeof(numProtocols),__FILE__,__LINE__);
    return(-1);
  }
  bytesWritten += rc;
  
  for (protoIter = (*this).begin(); protoIter != (*this).end(); protoIter++) {
    protocol = (*protoIter).first;
    rc = g_CfdArtsPrimitive.FdWrite(fd,&protocol,sizeof(protocol));
    if (rc < (int)sizeof(protocol)) {
      syslog(LOG_ERR,"[E] FdWrite(%d,%p,%d) failed: %m {%s:%d}",
             fd,&protocol,sizeof(protocol),__FILE__,__LINE__);
      return(-1);
    }
    bytesWritten += rc;
    
    rc = (*protoIter).second.write(fd);
    if (rc < 0) {
      syslog(LOG_ERR,"[E] (*protoIter).second.write(%d) failed: %m {%s:%d}",
             fd,__FILE__,__LINE__);
      return(-1);
    }
    bytesWritten += rc;
  }
  fsync(fd);
  
  return(bytesWritten);
}

//-------------------------------------------------------------------------
//    ostream& operator << (ostream& os,                   
//                          const CflowdProtocolTable & protocolTable) 
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream& operator << (ostream& os,
                      const CflowdProtocolTable & protocolTable)
{
  CflowdProtocolTable::const_iterator  protoIter;

  for (protoIter = protocolTable.begin();
       protoIter != protocolTable.end(); protoIter++) {
    os << "PROTOCOL ENTRY" << endl
       << "  protocol: " << (uint16_t)(*protoIter).first << endl
       << "   packets: " << (*protoIter).second.Pkts() << endl
       << "     bytes: " << (*protoIter).second.Bytes() << endl;
  }
  return(os);
}
