//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdRawFlowConverter.cc,v 1.5 1999/02/04 22:03:18 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

extern "C" {
#include <assert.h>
}

#include <string>

#include "CflowdRawFlowConverter.hh"

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdRawFlowConverter.cc,v 1.5 1999/02/04 22:03:18 dwm Exp $";

//-------------------------------------------------------------------------
//  vector<CflowdRawFlow> *                         
//  CflowdRawFlowConverter::ToFlowVector(ipv4addr_t ciscoIpAddr, 
//                                  const CiscoFlowHeaderV1_t * flowHeader, 
//                                  const CiscoFlowEntryV1_t * flowEntry)
//.........................................................................
//  
//-------------------------------------------------------------------------
vector<CflowdRawFlow> *
CflowdRawFlowConverter::ToFlowVector(ipv4addr_t ciscoIpAddr,
                                     const CiscoFlowHeaderV1_t * flowHeader,
                                     const CiscoFlowEntryV1_t * flowEntry)
{
  vector<CflowdRawFlow> *newFlowVector = new vector<CflowdRawFlow>();
  assert(newFlowVector != (vector<CflowdRawFlow> *)0);
  (*newFlowVector).reserve(ntohs(flowHeader->count));

  uint16_t  flowNum;
  
  for (flowNum = 0; flowNum < ntohs(flowHeader->count); flowNum++) {
    CflowdRawFlow newFlow = CflowdRawFlow(ciscoIpAddr,flowHeader,
                                          &flowEntry[flowNum]);
    (*newFlowVector).push_back(newFlow);
  }
  return(newFlowVector);
}

//-------------------------------------------------------------------------
//  void
//  CflowdRawFlowConverter::AddToFlowVector(vector<CflowdRawFlow> & flowVector,
//                              ipv4addr_t ciscoIpAddr,
//                              const CiscoFlowHeaderV1_t * flowHeader,
//                              const CiscoFlowEntryV1_t * flowEntry)      
//.........................................................................
//  
//-------------------------------------------------------------------------
void
CflowdRawFlowConverter::AddToFlowVector(vector<CflowdRawFlow> & flowVector,
                                        ipv4addr_t ciscoIpAddr,
                                        const CiscoFlowHeaderV1_t * flowHeader,
                                        const CiscoFlowEntryV1_t * flowEntry)
{
  uint16_t  flowNum;

  flowVector.reserve(flowVector.size() + ntohs(flowHeader->count));

  for (flowNum = 0; flowNum < ntohs(flowHeader->count); flowNum++) {
    CflowdRawFlow newFlow = CflowdRawFlow(ciscoIpAddr,flowHeader,
                                          &flowEntry[flowNum]);
    flowVector.push_back(newFlow);
  }
  return;
}

//-------------------------------------------------------------------------
//  vector<CflowdRawFlow> *                         
//  CflowdRawFlowConverter::ToFlowVector(ipv4addr_t ciscoIpAddr, 
//                                 const CiscoFlowHeaderV5_t * flowHeader, 
//                                 const CiscoFlowEntryV5_t * flowEntry)
//.........................................................................
//  
//-------------------------------------------------------------------------
vector<CflowdRawFlow> *
CflowdRawFlowConverter::ToFlowVector(ipv4addr_t ciscoIpAddr,
                                     const CiscoFlowHeaderV5_t * flowHeader,
                                     const CiscoFlowEntryV5_t * flowEntry)
{
  vector<CflowdRawFlow> *newFlowVector = new vector<CflowdRawFlow>();
  assert(newFlowVector != (vector<CflowdRawFlow> *)0);
  (*newFlowVector).reserve(ntohs(flowHeader->count));

  uint16_t  flowNum;
  
  for (flowNum = 0; flowNum < ntohs(flowHeader->count); flowNum++) {
    CflowdRawFlow newFlow = CflowdRawFlow(ciscoIpAddr,flowHeader,
                                          &flowEntry[flowNum]);
    (*newFlowVector).push_back(newFlow);
  }
  return(newFlowVector);
}

//---------------------------------------------------------------------------
//  vector<CflowdRawFlow> *
//  CflowdRawFlowConverter::ToFlowVector(ipv4addr_t ciscoIpAddr,
//                                  const CiscoFlowHeaderV6_t * flowHeader,
//                                  const CiscoFlowEntryV6_t * flowEntry)
//...........................................................................
//
//---------------------------------------------------------------------------
vector<CflowdRawFlow> *
CflowdRawFlowConverter::ToFlowVector(ipv4addr_t ciscoIpAddr,
                                     const CiscoFlowHeaderV6_t * flowHeader,
                                     const CiscoFlowEntryV6_t * flowEntry)
{
  vector<CflowdRawFlow> *newFlowVector = new vector<CflowdRawFlow>();
  assert(newFlowVector != (vector<CflowdRawFlow> *)0);
  (*newFlowVector).reserve(ntohs(flowHeader->count));

  uint16_t  flowNum;
  
  for (flowNum = 0; flowNum < ntohs(flowHeader->count); flowNum++) {
    CflowdRawFlow newFlow = CflowdRawFlow(ciscoIpAddr,flowHeader,
                                          &flowEntry[flowNum]);
    (*newFlowVector).push_back(newFlow);
  }
  return(newFlowVector);
}

//-------------------------------------------------------------------------
//  void
//  CflowdRawFlowConverter::AddToFlowVector(vector<CflowdRawFlow> & flowVector,
//                               ipv4addr_t ciscoIpAddr,
//                               const CiscoFlowHeaderV6_t * flowHeader,
//                               const CiscoFlowEntryV6_t * flowEntry);
//.........................................................................
//
//-------------------------------------------------------------------------
void
CflowdRawFlowConverter::AddToFlowVector(vector<CflowdRawFlow> & flowVector,
                                        ipv4addr_t ciscoIpAddr,
                                        const CiscoFlowHeaderV6_t * flowHeader,
                                        const CiscoFlowEntryV6_t * flowEntry)
{
  uint16_t  flowNum;
  
  flowVector.reserve(flowVector.size() + ntohs(flowHeader->count));

  for (flowNum = 0; flowNum < ntohs(flowHeader->count); flowNum++) {
    CflowdRawFlow newFlow = CflowdRawFlow(ciscoIpAddr,flowHeader,
                                          &flowEntry[flowNum]);
    flowVector.push_back(newFlow);
  }
  return;
}
