//===========================================================================
//  $Name: cflowd-2-1-b1 $
//  $Id: CflowdTableRequest.cc,v 1.5 1998/12/11 10:17:53 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#include <string>

#include "CflowdTableRequest.hh"

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdTableRequest.cc,v 1.5 1998/12/11 10:17:53 dwm Exp $";

//-------------------------------------------------------------------------
//                   int CflowdTableRequest::Read(int fd)                  
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdTableRequest::Read(int fd)
{
  int  rc;
  int  bytesRead = 0;

  if ((rc = g_CfdArtsPrimitive.FdRead(fd,&this->_routerIpAddr,
                                      sizeof(this->_routerIpAddr))) <
       (int)sizeof(this->_routerIpAddr))
    return(-1);
  bytesRead += rc;

  if ((rc = g_CfdArtsPrimitive.ReadUint16(fd,this->_tableIndex,
                                          sizeof(this->_tableIndex))) <
      (int)sizeof(this->_tableIndex))
    return(-1);
  bytesRead += rc;

  return(bytesRead);
}

//-------------------------------------------------------------------------
//                 CflowdTableRequest::Write(int fd) const                 
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdTableRequest::Write(int fd) const
{
  int  rc;
  int  bytesWritten = 0;

  if ((rc = g_CfdArtsPrimitive.FdWrite(fd,&this->_routerIpAddr,
                                       sizeof(this->_routerIpAddr))) <
      (int)sizeof(this->_routerIpAddr))
    return(-1);

  bytesWritten += rc;

  if ((rc = g_CfdArtsPrimitive.WriteUint16(fd,this->_tableIndex,
                                           sizeof(this->_tableIndex))) <
      (int)sizeof(this->_tableIndex))
    return(-1);
  fsync(fd);
  
  bytesWritten += rc;

  return(bytesWritten);
}
