//===========================================================================
//  @(#) $Name: cflowd-2-1-b1 $
//  @(#) $Id: CflowdTosTable.cc,v 1.1 1999/04/30 20:02:17 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#include <string>

#include "CflowdTosTable.hh"

#define k_flowTosTableFieldsMask (CflowdRawFlow::k_tosMask|\
                                       CflowdRawFlow::k_pktsMask|\
                                       CflowdRawFlow::k_bytesMask)

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdTosTable.cc,v 1.1 1999/04/30 20:02:17 dwm Exp $";

//-------------------------------------------------------------------------
//        int CflowdTosTable::AddFlow(const CflowdRawFlow & flow)       
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdTosTable::AddFlow(const CflowdRawFlow & flow)
{
  if ((flow.Index() & k_flowTosTableFieldsMask) ==
      k_flowTosTableFieldsMask) {
    ((*this)[flow.Tos()]).AddPkts(flow.Pkts());
    ((*this)[flow.Tos()]).AddBytes(flow.Bytes());
    return(0);
  }

  return(-1);
}

//-------------------------------------------------------------------------
//            istream & CflowdTosTable::read(istream & is)            
//.........................................................................
//  
//-------------------------------------------------------------------------
istream & CflowdTosTable::read(istream & is)
{
  uint8_t                            numToss;
  uint8_t                            tosNum;
  uint8_t                            tos;
  CflowdTosTableTrafficCounter  protoTraffic;
  
  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }

  is.read(&numToss,sizeof(numToss));
  for (tosNum = 0; tosNum < numToss; tosNum++) {
    is.read(&tos,sizeof(tos));
    protoTraffic.read(is);
    (*this)[tos] = protoTraffic;
  }
  return(is);
}

//-------------------------------------------------------------------------
//                  int CflowdTosTable::read(int fd)                  
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdTosTable::read(int fd)
{
  uint8_t                            numToss;
  uint8_t                            tosNum;
  uint8_t                            tos;
  CflowdTosTableTrafficCounter  protoTraffic;
  int                                rc;
  int                                bytesRead = 0;
  
  if ((*this).size() > 0) {
    (*this).erase((*this).begin(),(*this).end());
  }

  rc = g_CfdArtsPrimitive.FdRead(fd,&numToss,sizeof(numToss));
  if (rc < (int)sizeof(numToss)) {
    syslog(LOG_ERR,"[E] FdRead(%d,%p,%d) failed: %m {%s:%d}",
           fd,&numToss,sizeof(numToss),__FILE__,__LINE__);
    return(-1);
  }
  bytesRead += rc;

  for (tosNum = 0; tosNum < numToss; tosNum++) {
    rc = g_CfdArtsPrimitive.FdRead(fd,&tos,sizeof(tos));
    if (rc < (int)sizeof(tos)) {
      syslog(LOG_ERR,"[E] FdRead(%d,%p,%d) failed: %m {%s:%d}",
             fd,&tos,sizeof(tos),__FILE__,__LINE__);
      return(-1);
    }
    bytesRead += rc;
    
    rc = protoTraffic.read(fd);
    if (rc < 0) {
      syslog(LOG_ERR,"[E] protoTraffic.read(%d) failed: %m {%s:%d}",
             fd,__FILE__,__LINE__);
      return(-1);
    }
    bytesRead += rc;
    
    (*this)[tos] = protoTraffic;
  }
  return(bytesRead);
}

//-------------------------------------------------------------------------
//         ostream & CflowdTosTable::write(ostream & os) const        
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream & CflowdTosTable::write(ostream & os) const
{
  uint8_t                              tos;
  uint8_t                              numToss;
  CflowdTosTable::const_iterator  protoIter;
  
  numToss = (*this).size();
  os.write(&numToss,sizeof(numToss));

  for (protoIter = (*this).begin(); protoIter != (*this).end(); protoIter++) {
    tos = (*protoIter).first;
    os.write(&tos,sizeof(tos));
    (*protoIter).second.write(os);
  }
  return(os);
}

//-------------------------------------------------------------------------
//               int CflowdTosTable::write(int fd) const              
//.........................................................................
//  
//-------------------------------------------------------------------------
int CflowdTosTable::write(int fd) const
{
  uint8_t                              tos;
  uint8_t                              numToss;
  CflowdTosTable::const_iterator  protoIter;
  int                                  rc;
  int                                  bytesWritten = 0;
  
  numToss = (*this).size();
  rc = g_CfdArtsPrimitive.FdWrite(fd,&numToss,sizeof(numToss));
  if (rc < (int)sizeof(numToss)) {
    syslog(LOG_ERR,"[E] FdWrite(%d,%p,%d) failed: %m {%s:%d}",
           fd,&numToss,sizeof(numToss),__FILE__,__LINE__);
    return(-1);
  }
  bytesWritten += rc;
  
  for (protoIter = (*this).begin(); protoIter != (*this).end(); protoIter++) {
    tos = (*protoIter).first;
    rc = g_CfdArtsPrimitive.FdWrite(fd,&tos,sizeof(tos));
    if (rc < (int)sizeof(tos)) {
      syslog(LOG_ERR,"[E] FdWrite(%d,%p,%d) failed: %m {%s:%d}",
             fd,&tos,sizeof(tos),__FILE__,__LINE__);
      return(-1);
    }
    bytesWritten += rc;
    
    rc = (*protoIter).second.write(fd);
    if (rc < 0) {
      syslog(LOG_ERR,"[E] (*protoIter).second.write(%d) failed: %m {%s:%d}",
             fd,__FILE__,__LINE__);
      return(-1);
    }
    bytesWritten += rc;
  }
  fsync(fd);
  
  return(bytesWritten);
}

//-------------------------------------------------------------------------
//    ostream& operator << (ostream& os,                   
//                          const CflowdTosTable & tosTable) 
//.........................................................................
//  
//-------------------------------------------------------------------------
ostream& operator << (ostream& os,
                      const CflowdTosTable & tosTable)
{
  CflowdTosTable::const_iterator  protoIter;

  for (protoIter = tosTable.begin();
       protoIter != tosTable.end(); protoIter++) {
    os << "TOS ENTRY" << endl
       << "  tos: " << (uint16_t)(*protoIter).first << endl
       << "   packets: " << (*protoIter).second.Pkts() << endl
       << "     bytes: " << (*protoIter).second.Bytes() << endl;
  }
  return(os);
}
