//===========================================================================
//  $Name: cflowd-2-1-b1 $
//  $Id: CflowdVersion.cc,v 1.1 1998/10/12 23:59:20 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
//  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
//  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#include "CflowdVersion.hh"

static const string rcsid = "@(#) $Name: cflowd-2-1-b1 $ $Id: CflowdVersion.cc,v 1.1 1998/10/12 23:59:20 dwm Exp $";

//-------------------------------------------------------------------------
//          CflowdVersion::CflowdVersion(const string & nameAndId)         
//.........................................................................
//  
//-------------------------------------------------------------------------
CflowdVersion::CflowdVersion(const string & nameAndId)
{
  const string  nameTag = string("$Name: ");
  const string  idTag = string("$Id: ");
  size_t        startPos = nameAndId.find(nameTag);
  size_t        endPos;
  
  if (startPos != nameAndId.npos) {
    startPos += nameTag.length();
    endPos = startPos;
    while (nameAndId[endPos] != ' ') {
      endPos++;
    }
    this->_name.assign(nameAndId,startPos,endPos-startPos);
  }

  startPos = nameAndId.find(idTag);
  if (startPos != nameAndId.npos) {
    startPos += idTag.length();
    endPos = startPos + 1;
    while (nameAndId[endPos] != '$') {
      endPos++;
    }
    this->_id.assign(nameAndId,startPos,endPos-startPos);
  }
}

//-------------------------------------------------------------------------
//                const string & CflowdVersion::Name() const               
//.........................................................................
//  
//-------------------------------------------------------------------------
const string & CflowdVersion::Name() const
{
  return(this->_name);
}

//-------------------------------------------------------------------------
//                 const string & CflowdVersion::Id() const                
//.........................................................................
//  
//-------------------------------------------------------------------------
const string & CflowdVersion::Id() const
{
  return(this->_id);
}

