dnl  ###  
dnl  ###  
dnl  ###  
define(DWM_PRESET_PATH,[
  case $1 in
    sbindir)
      if test "$[$1]" = '${exec_prefix}/sbin'; then
        $1=$2
      fi
      ;;
    datadir)
      if test "$[$1]" = '${prefix}/share'; then
        $1=$2
      fi
      ;;
    bindir)
      if test "$[$1]" = '${exec_prefix}/bin'; then
        $1=$2
      fi
      ;;
    libdir)
      if test "$[$1]" = '${exec_prefix}/lib'; then
        $1=$2
      fi
      ;;
    libexecdir)
      if test "$[$1]" = '${exec_prefix}/libexec'; then
        $1=$2
      fi
      ;;
    sysconfdir)
      if test "$[$1]" = '${prefix}/etc'; then
        $1=$2
      fi
      ;;
    sharedstatedir)
      if test "$[$1]" = '${prefix}/com'; then
        $1=$2
      fi
      ;;
    localstatedir)
      if test "$[$1]" = '${prefix}/var'; then
        $1=$2
      fi
      ;;
    infodir)
      if test "$[$1]" = '${prefix}/info'; then
        $1=$2
      fi
      ;;
    mandir)
      if test "$[$1]" = '${prefix}/man'; then
        $1=$2
      fi
      ;;
    srcdir)
      ;;
    includedir)
      if test "$[$1]" = '${prefix}/include'; then
        $1=$2
      fi
      ;;
    *)
      ;;
  esac
  if test -z "$dwm_install_max_name_len" ; then
    dwm_install_max_name_len=`echo [$1] | wc -c | cut -f1`
    dwm_install_max_name_len=`expr $dwm_install_max_name_len`
  else
    if test `echo [$1] | wc -c` -ge [$dwm_install_max_name_len] ; then
      dwm_install_max_name_len=`echo [$1] | wc -c | cut -f1`
      dwm_install_max_name_len=`expr $dwm_install_max_name_len`
    fi
  fi
  dwm_preset_path_names="$dwm_preset_path_names $1"
  dwm_preset_path_values="$dwm_preset_path_values $[$1]"
])


dnl  #############################################################
dnl  ###  Function to add a path for an installation directory.  #
dnl  ###  We'll check/set the variable whose name is passed      #
dnl  ###  as the first argument ($1), which is also a '--with-'  #
dnl  ###  argument for configure.  The second argument should    #
dnl  ###  be the default value for the variable named by $1.     #
dnl  #############################################################
define(DWM_INSTALL_PATH,[
  $1=$2
  AC_ARG_WITH([$1],
              [  --with-$1=value set default \$$1 to value],
              [$1=$withval; /usr/bin/printf "%s set to %s\n" [$1] $withval],
	      [/usr/bin/printf "%s set to %s [(default)]\n" [$1] [$2]]
  )dnl
  AC_SUBST([$1])
  if test -z "$dwm_install_max_name_len" ; then
    dwm_install_max_name_len=`echo [$1] | wc -c | cut -f1`
    dwm_install_max_name_len=`expr $dwm_install_max_name_len`
  else
    if test `echo [$1] | wc -c | cut -f1` -ge [$dwm_install_max_name_len] ; then
      dwm_install_max_name_len=`echo [$1] | wc -c | cut -f1`
      dwm_install_max_name_len=`expr $dwm_install_max_name_len`
    fi
  fi
  dwm_install_names="$dwm_install_names $1"
  dwm_install_vals="$dwm_install_vals $[$1]"
])dnl

dnl  #############################################################
dnl  ###  Function to add a path for a prerequisite.             #
dnl  ###  The prerequisite is the variable whose name is passed  #
dnl  ###  as the first argument, which is also a '--with-'       #
dnl  ###  argument for configure.  The second argument should    #
dnl  ###  be the default value for the variable named by $1.     #
dnl  #############################################################
define(DWM_PREREQ_PATH,[
  $1=$2
  AC_ARG_WITH([$1],
    [  --with-$1=value   set \$$1 to value ($3)],
    [$1=$withval; /usr/bin/printf "%s set to %s\n" [$1] $withval],
    [/usr/bin/printf "%s set to %s [(default)]\n" [$1] [$2]]
  )dnl
  AC_SUBST([$1])
  if test -z "$dwm_prereq_max_name_len" ; then
    dwm_prereq_max_name_len=`echo [$1] | wc -c | cut -f1`
    dwm_prereq_max_name_len=`expr $dwm_prereq_max_name_len`
  else
    if test `echo [$1] | wc -c | cut -f1` -ge $dwm_prereq_max_name_len ; then
      dwm_prereq_max_name_len=`echo [$1] | wc -c | cut -f1`
      dwm_prereq_max_name_len=`expr $dwm_prereq_max_name_len`
    fi
  fi
  dwm_prereq_names="$dwm_prereq_names $1"
  dwm_prereq_vals="$dwm_prereq_vals $[$1]"
])dnl

dnl  #############################################################
dnl  ###  Function to list prereq paths added with               #
dnl  ###  DWM_PREREQ_PATH.                                       #
dnl  #############################################################
define(DWM_LIST_PREREQ_PATHS,[
[
/bin/echo ""
/bin/echo "Prereq paths:"
dwm_name_index=0
for dwm_prereq_name in $dwm_prereq_names ; do
  dwm_val_index=0
  for dwm_prereq_value in $dwm_prereq_vals ; do
    if test "$dwm_name_index" = "$dwm_val_index"; then
      /usr/bin/printf "    %${dwm_prereq_max_name_len}s:  %s\n" $dwm_prereq_name $dwm_prereq_value
    fi
    dwm_val_index=`expr $dwm_val_index + 1`
  done
  dwm_name_index=`expr $dwm_name_index + 1`
done
/bin/echo ""
]
])

dnl  #############################################################
dnl  ###  Function to list the paths added with                  #
dnl  ###  DWM_INSTALL_PATH.                                      #
dnl  #############################################################
define(DWM_LIST_INSTALL_PATHS,[
[
/bin/echo ""
/bin/echo "Install paths: "
dwm_name_index=0
for dwm_install_name in $dwm_install_names ; do
  dwm_val_index=0
  for dwm_install_value in $dwm_install_vals ; do
    if test "$dwm_name_index" = "$dwm_val_index"; then
      /usr/bin/printf "    %${dwm_install_max_name_len}s:  %s\n" $dwm_install_name $dwm_install_value
    fi
    dwm_val_index=`expr $dwm_val_index + 1`
  done
  dwm_name_index=`expr $dwm_name_index + 1`
done
dwm_name_index=0
for dwm_install_name in $dwm_preset_path_names ; do
  dwm_val_index=0
  for dwm_install_value in $dwm_preset_path_values ; do
    if test "$dwm_name_index" = "$dwm_val_index"; then
      /usr/bin/printf "    %${dwm_install_max_name_len}s:  %s\n" $dwm_install_name $dwm_install_value
    fi
    dwm_val_index=`expr $dwm_val_index + 1`
  done
  dwm_name_index=`expr $dwm_name_index + 1`
done

/bin/echo ""
]
])

dnl  #############################################################
dnl  ###  Cheesy function to set (and substitute for) a variable
dnl  ###  named by [$1] (first argument).  [$2] is expected to 
dnl  ###  contain an RCS 'Name:' tag (with the dollar signs).
dnl  ###  If substitution has taken place for 'Name:' (via 
dnl  ###  'cvs export -r foo' or the like), we pull the value
dnl  ###  out of the tag string and set the variable named by
dnl  ###  [$1] to it.  If no substitution has been performed for 
dnl  ###  the 'Name:' tag, the [$3] value will be used.
dnl  #############################################################
define(DWM_SET_VERSION,[
  $1=`echo '[$2]' | sed 's/\$Name\:[[ ]]*//1' | sed 's/[[ $]]//g'`
  if test "$$1" = "" ; then
    $1=$3
  fi
  echo "$1 set to $$1"
  AC_SUBST([$1])dnl
])
