//===========================================================================
//  $Name: cflowd-2-1-b1 $
//  $Id: flowpdu.h,v 1.1 1998/09/09 21:44:02 dwm Exp $
//===========================================================================
//  CAIDA Copyright Notice
//
//  By accessing this software, cflowd++, you are duly informed
//  of and agree to be bound by the conditions described below in this
//  notice:
//
//  This software product, cflowd++, is developed by Daniel W. McRobb, and
//  copyrighted(C) 1998 by the University of California, San Diego
//  (UCSD), with all rights reserved.  UCSD administers the CAIDA grant,
  //  NCR-9711092, under which part of this code was developed.
//
//  There is no charge for cflowd++ software. You can redistribute it
//  and/or modify it under the terms of the GNU General Public License,
  //  v.  2 dated June 1991 which is incorporated by reference herein.
//  cflowd++ is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS, OF
//  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that the use
//  of it will not infringe on any third party's intellectual property
//  rights.
//
//  You should have received a copy of the GNU GPL along with cflowd++.
//  Copies can also be obtained from:
//
//    http://www.gnu.org/copyleft/gpl.html
//
//  or by writing to:
//
//    University of California, San Diego
//
//    SDSC/CAIDA
//    9500 Gilman Dr., MS-0505
//    La Jolla, CA 92093 - 0505  USA
//
//  Or contact:
//
//    info@caida.org
//===========================================================================

#ifndef _FLOWPDU_H_
#define _FLOWPDU_H_

#include "caida_t.h"

typedef struct {
  uint16_t    version;         /* flow-export PDU version  */
  uint16_t    count;           /* The number of records in PDU  */
  uint32_t    SysUptime;       /* time in millisecs since router booted */
  uint32_t    unix_secs;       /* Current seconds since 0000 UTC 1970 */
  uint32_t    unix_nsecs;      /* Residual nanoseconds since 0000 UTC 1970 */
  uint32_t    flow_sequence;   /* Seq counter of total flows seen */
  uint32_t    reserved;
} FLOW_PDU_HDR;


#define FLOWSTATHDR_VERSION 3
#define MAXFLOWS 30

typedef struct {
  ipv4addr_t   srcaddr;      /* Source IP Address */
  ipv4addr_t   dstaddr;      /* Destination IP Address */
  ipv4addr_t   nexthop;      /* Next hop router's IP Address */
  uint16_t     input;       /* Input interface index */
  uint16_t     output;      /* Output interface index */
  uint32_t     dPkts;       /* Packets sent in Duration */
  uint32_t     dOctets;     /* Octets sent in Duration. */
  uint32_t     First;       /* SysUptime at start of flow */
  uint32_t     Last;        /* and of last packet of flow */
  uint16_t     srcport;     /* TCP/UDP source port number or equivalent */
  uint16_t     dstport;     /* TCP/UDP destination port number or equivalent */
  uint8_t      pad;  
  uint8_t      tcp_flags;   /*  logical OR of all TCP flags in flow; 0x10
				for non-TCP flows  */
  uint8_t      prot;        /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
  uint8_t      tos;         /* IP Type-of-Service */
  uint16_t     src_as;      /* originating AS of source address */
  uint16_t     dst_as;      /* originating AS of destination address */
  uint8_t      src_mask;    /* source address prefix mask bits */
  uint8_t      dst_mask;    /* destination address prefix mask bits */
  uint16_t     reserved;  
} FLOW_PDU_ENTRY;

typedef struct {
  FLOW_PDU_HDR    header;
  FLOW_PDU_ENTRY  entry[MAXFLOWS];
} FLOW_PDU;

typedef struct {
  ipv4addr_t         fromaddr;
  FLOW_PDU          *flowpdu;
} FLOW_FADDR_AND_PDU;


/*  A reasonable on-disk format for a flow stat?  */

#define FLOW_ENTRY_SRCADDR_MASK       0x00000001
#define FLOW_ENTRY_DSTADDR_MASK       0x00000002
#define FLOW_ENTRY_INPUT_IF_MASK      0x00000004
#define FLOW_ENTRY_OUTPUT_IF_MASK     0x00000008
#define FLOW_ENTRY_SRC_PORT_MASK      0x00000010
#define FLOW_ENTRY_DST_PORT_MASK      0x00000020
#define FLOW_ENTRY_PKTS_MASK          0x00000040
#define FLOW_ENTRY_BYTES_MASK         0x00000080
#define FLOW_ENTRY_NEXT_HOP_MASK      0x00000100
#define FLOW_ENTRY_START_TIME_MASK    0x00000200
#define FLOW_ENTRY_END_TIME_MASK      0x00000400
#define FLOW_ENTRY_PROTOCOL_MASK      0x00000800
#define FLOW_ENTRY_TOS_MASK           0x00001000
#define FLOW_ENTRY_SRC_AS_MASK        0x00002000
#define FLOW_ENTRY_DST_AS_MASK        0x00004000
#define FLOW_ENTRY_SRC_NETMASK_MASK   0x00008000
#define FLOW_ENTRY_DST_NETMASK_MASK   0x00010000
#define FLOW_ENTRY_TCP_FLAGS_MASK     0x00020000

typedef struct {
  uint32_t        index;        /* bitmask indicating presence of other
				   * fields                                 */
  ipv4addr_t        srcaddr;      /* Source IP Address                      */
  ipv4addr_t        dstaddr;      /* Destination IP Address                 */
  uint8_t           descriptor;   /*  bits telling us how big these are:
				   *   - input_if  (1 or 2 bytes)
				   *   - output_if (1 or 2 bytes)
				   *   - dstport   (1 or 2 bytes)
				   *   - srcport   (1 or 2 bytes)
				   *   - dPkts     (1 to 4 bytes)
				   *   - dOctets   (1 to 4 bytes)
				   *  +---+---+---+---+---+---+---+---+
                                   *  |   |   |   |   |       |   b   |
				   *  |i i|o i|s p|d p|   p   |   y   |
				   *  |n n|u n|r o|s o|   k   |   t   |
				   *  |  t|t t|c r|t r|   t   |   e   |
				   *  |  f|  f|  t|  t|   s   |   s   |
				   *  +---+---+---+---+---+---+---+---+
				   *  | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
				   *   MSB                         LSB
				   *  The actual value is gained by adding
				   *  1 to the number in the bitfield.      */
  uint16_t          input_if;     /* Input interface index                  */
  uint16_t          output_if;    /* Output interface index                 */
  uint16_t          srcport;      /* TCP/UDP src port number or equivalent  */
  uint16_t          dstport;      /* TCP/UDP dst port number or equivalent  */
  uint32_t          pkts;         /* Packets sent in Duration               */
  uint32_t          bytes;        /* Octets sent in Duration.               */
  ipv4addr_t        nexthop;      /* Next hop router's IP Address           */
  uint32_t          starttime;    /* SysUptime at start of flow             */
  uint32_t          endtime;      /* and of last packet of flow             */
  uint8_t           protocol;     /* IP protocol, e.g., 6=TCP, 17=UDP, ...  */
  uint8_t           tos;          /* IP Type-of-Service                     */
  uint16_t          src_as;       /* originating AS of source address       */
  uint16_t          dst_as;       /* originating AS of destination address  */
  uint8_t           src_mask;     /* source address prefix mask bits        */
  uint8_t           dst_mask;     /* destination address prefix mask bits   */
  uint8_t           tcp_flags;    /* logical OR of all TCP flags in flow; 
				     0x10 for non-TCP flows                 */
} artsDATA_CISCO_FLOW_ENTRY;

#define FLOW_TABLE_CISCO_VERSION_MASK   0x01  /*  indicates presence of
						  cisco_version             */
#define FLOW_TABLE_SYSUPTIME_MASK       0x02  /*  indicates presence of
						  SysUptime                 */
#define FLOW_TABLE_UNIX_SECS_MASK       0x02  /*  indicates presence of
                                                  unix_secs                 */
#define FLOW_TABLE_UNIX_NSECS_MASK      0x04  /*  indicates presence of
						  unix_nsecs                */
#define FLOW_TABLE_FLOW_SEQ_MASK        0x08  /*  indicates presence of 
						  flow_sequence             */
#define FLOW_TABLE_FLOW_ENTRIES_MASK    0x10  /*  indicates presence of 
						  descriptor, num_entries
						  and entries               */

typedef struct {
  uint8_t                     index;        /* what's present?              */
  uint16_t                    cisco_vers;   /* cisco flow PDU version       */
  uint32_t                    sysUpTime;    /* obvious?                     */
  uint32_t                    unix_secs;    /* secs since epoch             */
  uint32_t                    unix_nsecs;   /* residual nsecs since epoch   */
  uint32_t                    flow_seq;     /* seq counter of tot. flows    */
  uint16_t                    num_entries;  /* number of entries            */
  artsDATA_CISCO_FLOW_ENTRY  *entries;
} artsDATA_CISCO_FLOW_TABLE;

#endif  // _FLOWPDU_H_
