/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999, 2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <gtk/gtkmain.h>
#include <gdk/gdkx.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "config.h"
#include "gimpgradient.h"

#ifndef MIN
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif

#define ServeEvents if (stop_changing) return; else while(gtk_events_pending()) gtk_main_iteration();


typedef void (*shader_func) (GdkPixmap *, GdkGC *, int, randshader_info *, gradient_t *, guchar *, int, int, int, int, absimg_rgb_t *, absimg_rgb_t *);

static void shader_noop();
static void shader_2();
static void shader_3();
static void shader_4();
static void shader_5();
static void shader_6();
static void shader_7();
static void shader_8();
static void shader_9();
static void shader_10();
static void shader_11();
static void shader_12();
static void shader_13();
static void shader_14();
static void shader_15();
static void shader_16();
static void shader_17();
static void shader_18();
static void shader_19();
static void shader_20();
static void shader_21();
static void shader_22();
static void shader_23();
static void shader_24();
static void shader_25();
static void shader_26();
static void shader_27();
static void shader_28();
static void shader_29();
static void shader_30();
static void shader_31();
static void shader_32();
static void shader_33();
static void shader_34();
static void shader_35();
static void shader_36();
static void shader_37();
static void shader_38();
static void shader_39();
static void shader_40();
static void shader_41();
static void shader_42();
static void shader_43();
static void shader_44();
static void shader_45();
static void shader_46();
static void shader_47();
static void shader_48();
static void shader_49();
static void shader_50();
static void shader_51();
static void shader_52();
static void shader_53();
static void shader_54();
static void shader_55();
static void shader_56();
static void shader_57();
static void shader_58();
static void shader_59();
static void shader_60();
static void shader_61();
static void shader_62();
static void shader_63();
static void shader_64();
static void shader_65();
static void shader_66();
static void shader_67();
static void shader_68();
static void shader_69();
static void shader_70();
static void shader_71();
static void shader_72();
static void shader_73();
static void shader_74();
static void shader_75();
static void shader_76();
static void shader_77();
static void shader_78();
static void shader_79();
static void shader_80();
static void shader_81();
static void shader_82();
static void shader_83();
static void shader_84();
static void shader_85();
static void shader_86();
static void shader_87();
static void shader_88();
static void shader_89();
static void shader_90();
static void shader_91();
static void shader_92();
static void shader_93();
static void shader_94();
static void shader_95();
static void shader_96();
static void shader_97();
static void shader_98();
static void shader_99();
static void shader_100();
static void shader_101();
static void shader_102();
static void shader_103();
static void shader_104();
static void shader_105();
static void shader_106();
static void shader_107();
static void shader_108();
static void shader_109();
static void shader_110();
static void shader_111();
static void shader_112();
static void shader_113();
static void shader_114();
static void shader_115();
static void shader_116();
static void shader_117();
static void shader_118();
static void shader_119();
static void shader_120();
static void shader_121();
static void shader_122();
static void shader_123();
static void shader_124();
static void shader_125();
static void shader_126();
static void shader_127();
static void shader_128();
static void shader_129();
static void shader_130();
static void shader_131();
static void shader_132();
static void shader_133();
static void shader_134();
static void shader_135();
static void shader_136();
static void shader_137();
static void shader_138();
static void shader_139();
static void shader_140();
static void shader_141();
static void shader_142();
static void shader_143();
static void shader_144();
static void shader_145();
static void shader_146();
static void shader_147();
static void shader_148();
static void shader_149();
static void shader_150();
static void shader_151();
static void shader_152();
static void shader_153();
static void shader_154();
static void shader_155();
static void shader_156();
static void shader_157();
static void shader_158();
static void shader_182();
static void shader_183();

struct {
	shader_func	func;
	int		par1;
	int		par2;
} shader_tab[] = {
	{shader_2, 0, 0} ,
	{shader_3, 0, 0} ,
	{shader_4, 0, 0} ,
	{shader_5, 0, 0} ,
	{shader_6, 0, 0} ,
	{shader_7, 0, 0} ,
	{shader_8, 0, 0} ,
	{shader_9, 0, 0} ,
	{shader_10, 0, 0} ,
	{shader_11, 0, 0} ,
	{shader_12, 0, 0} ,
	{shader_13, 0, 0} ,
	{shader_14, 0, 0} ,
	{shader_15, 0, 0} ,
	{shader_16, 0, 0} ,
	{shader_17, 0, 0} ,
	{shader_18, 0, 0} ,
	{shader_19, 0, 0} ,
	{shader_20, 0, 0} ,
	{shader_21, 0, 0} ,
	{shader_22, 0, 0} ,
	{shader_23, 0, 0} ,
	{shader_24, 0, 0} ,
	{shader_25, 0, 0} ,
	{shader_26, 0, 0} ,
	{shader_27, 0, 0} ,
	{shader_28, 0, 0} ,
	{shader_29, 0, 0} ,
	{shader_30, 0, 0} ,
	{shader_31, 0, 0} ,
	{shader_32, 0, 0} ,
	{shader_33, 0, 0} ,
	{shader_34, 0, 0} ,
	{shader_35, 0, 0} ,
	{shader_36, 0, 0} ,
	{shader_37, 0, 0} ,
	{shader_38, 0, 0} ,
	{shader_39, 0, 0} ,
	{shader_40, 0, 0} ,
	{shader_41, 0, 0} ,
	{shader_42, 0, 0} ,
	{shader_43, 0, 0} ,
	{shader_44, 0, 0} ,
	{shader_45, 0, 0} ,
	{shader_46, 0, 0} ,
	{shader_47, 0, 0} ,
	{shader_48, 0, 0} ,
	{shader_49, 0, 0} ,
	{shader_50, 0, 0} ,
	{shader_51, 0, 0} ,
	{shader_52, 0, 0} ,
	{shader_53, 0, 0} ,
	{shader_54, 0, 0} ,
	{shader_55, 0, 0} ,
	{shader_56, 0, 0} ,
	{shader_57, 0, 0} ,
	{shader_58, 0, 0} ,
	{shader_59, 0, 0} ,
	{shader_60, 0, 0} ,
	{shader_61, 0, 0} ,
	{shader_62, 0, 0} ,
	{shader_63, 0, 0} ,
	{shader_64, 0, 0} ,
	{shader_65, 0, 0} ,
	{shader_66, 0, 0} ,
	{shader_67, 0, 0} ,
	{shader_68, 0, 0} ,
	{shader_69, 0, 0} ,
	{shader_70, 0, 0} ,
	{shader_71, 0, 0} ,
	{shader_72, 0, 0} ,
	{shader_73, 0, 0} ,
	{shader_74, 0, 0} ,
	{shader_75, 0, 0} ,
	{shader_76, 0, 0} ,
	{shader_77, 0, 0} ,
	{shader_78, 0, 0} ,
	{shader_79, 0, 0} ,
	{shader_80, 0, 0} ,
	{shader_81, 0, 0} ,
	{shader_82, 0, 0} ,
	{shader_83, 0, 0} ,
	{shader_84, 0, 0} ,
	{shader_85, 0, 0} ,
	{shader_86, 0, 0} ,
	{shader_87, 0, 0} ,
	{shader_88, 0, 0} ,
	{shader_89, 0, 0} ,
	{shader_90, 0, 0} ,
	{shader_90, 1, 0} ,
	{shader_90, 2, 0} ,
	{shader_90, 3, 0} ,
	{shader_90, 4, 0} ,
	{shader_90, 5, 0} ,
	{shader_90, 6, 0} ,
	{shader_90, 8, 0} ,
	{shader_90, 9, 0} ,
	{shader_90, 10, 0} ,
	{shader_90, 11, 0} ,
	{shader_90, 12, 0} ,
	{shader_91, 0, 0} ,
	{shader_91, 1, 0} ,
	{shader_91, 2, 0} ,
	{shader_91, 3, 0} ,
	{shader_91, 4, 0} ,
	{shader_91, 5, 0} ,
	{shader_91, 6, 0} ,
	{shader_91, 8, 0} ,
	{shader_91, 9, 0} ,
	{shader_91, 10, 0} ,
	{shader_91, 11, 0} ,
	{shader_91, 12, 0} ,
	{shader_92, 0, 0} ,
	{shader_92, 1, 0} ,
	{shader_92, 2, 0} ,
	{shader_92, 3, 0} ,
	{shader_92, 4, 0} ,
	{shader_92, 5, 0} ,
	{shader_92, 6, 0} ,
	{shader_92, 8, 0} ,
	{shader_92, 9, 0} ,
	{shader_92, 10, 0} ,
	{shader_92, 11, 0} ,
	{shader_92, 12, 0} ,
	{shader_93, 0, 0} ,
	{shader_93, 1, 0} ,
	{shader_93, 2, 0} ,
	{shader_93, 3, 0} ,
	{shader_93, 4, 0} ,
	{shader_93, 5, 0} ,
	{shader_93, 6, 0} ,
	{shader_93, 8, 0} ,
	{shader_93, 9, 0} ,
	{shader_93, 10, 0} ,
	{shader_93, 11, 0} ,
	{shader_93, 12, 0} ,
	{shader_94, 0, 0} ,
	{shader_94, 1, 0} ,
	{shader_94, 2, 0} ,
	{shader_94, 3, 0} ,
	{shader_94, 4, 0} ,
	{shader_94, 5, 0} ,
	{shader_94, 6, 0} ,
	{shader_94, 8, 0} ,
	{shader_94, 9, 0} ,
	{shader_94, 10, 0} ,
	{shader_94, 11, 0} ,
	{shader_94, 12, 0} ,
	{shader_95, 0, 0} ,
	{shader_95, 1, 0} ,
	{shader_95, 2, 0} ,
	{shader_95, 3, 0} ,
	{shader_95, 4, 0} ,
	{shader_95, 5, 0} ,
	{shader_95, 6, 0} ,
	{shader_95, 8, 0} ,
	{shader_95, 9, 0} ,
	{shader_95, 10, 0} ,
	{shader_95, 11, 0} ,
	{shader_95, 12, 0} ,
	{shader_96, 0, 0} ,
	{shader_96, 1, 0} ,
	{shader_96, 2, 0} ,
	{shader_96, 3, 0} ,
	{shader_96, 4, 0} ,
	{shader_96, 5, 0} ,
	{shader_96, 6, 0} ,
	{shader_96, 8, 0} ,
	{shader_96, 9, 0} ,
	{shader_96, 10, 0} ,
	{shader_96, 11, 0} ,
	{shader_96, 12, 0} ,
	{shader_97, 0, 0} ,
	{shader_97, 1, 0} ,
	{shader_97, 2, 0} ,
	{shader_97, 3, 0} ,
	{shader_97, 4, 0} ,
	{shader_97, 5, 0} ,
	{shader_97, 6, 0} ,
	{shader_97, 8, 0} ,
	{shader_97, 9, 0} ,
	{shader_97, 10, 0} ,
	{shader_97, 11, 0} ,
	{shader_97, 12, 0} ,
	{shader_98, 0, 0} ,
	{shader_98, 1, 0} ,
	{shader_98, 2, 0} ,
	{shader_98, 3, 0} ,
	{shader_98, 4, 0} ,
	{shader_98, 5, 0} ,
	{shader_98, 6, 0} ,
	{shader_98, 8, 0} ,
	{shader_98, 9, 0} ,
	{shader_98, 10, 0} ,
	{shader_98, 11, 0} ,
	{shader_98, 12, 0} ,
	{shader_99, 0, 0} ,
	{shader_99, 1, 0} ,
	{shader_99, 2, 0} ,
	{shader_99, 3, 0} ,
	{shader_99, 4, 0} ,
	{shader_99, 5, 0} ,
	{shader_99, 6, 0} ,
	{shader_99, 8, 0} ,
	{shader_99, 9, 0} ,
	{shader_99, 10, 0} ,
	{shader_99, 11, 0} ,
	{shader_99, 12, 0} ,
	{shader_100, 0, 0} ,
	{shader_100, 1, 0} ,
	{shader_100, 2, 0} ,
	{shader_100, 3, 0} ,
	{shader_100, 4, 0} ,
	{shader_100, 5, 0} ,
	{shader_100, 6, 0} ,
	{shader_100, 8, 0} ,
	{shader_100, 9, 0} ,
	{shader_100, 10, 0} ,
	{shader_100, 11, 0} ,
	{shader_100, 12, 0} ,
	{shader_101, 0, 0} ,
	{shader_101, 1, 0} ,
	{shader_101, 2, 0} ,
	{shader_101, 3, 0} ,
	{shader_101, 4, 0} ,
	{shader_101, 5, 0} ,
	{shader_101, 6, 0} ,
	{shader_101, 8, 0} ,
	{shader_101, 9, 0} ,
	{shader_101, 10, 0} ,
	{shader_101, 11, 0} ,
	{shader_101, 12, 0} ,
	{shader_102, 0, 0} ,
	{shader_102, 1, 0} ,
	{shader_102, 2, 0} ,
	{shader_102, 3, 0} ,
	{shader_102, 4, 0} ,
	{shader_102, 5, 0} ,
	{shader_102, 6, 0} ,
	{shader_102, 8, 0} ,
	{shader_102, 9, 0} ,
	{shader_102, 10, 0} ,
	{shader_102, 11, 0} ,
	{shader_102, 12, 0} ,
	{shader_103, 0, 0} ,
	{shader_103, 1, 0} ,
	{shader_103, 2, 0} ,
	{shader_103, 3, 0} ,
	{shader_103, 4, 0} ,
	{shader_103, 5, 0} ,
	{shader_103, 6, 0} ,
	{shader_103, 8, 0} ,
	{shader_103, 9, 0} ,
	{shader_103, 10, 0} ,
	{shader_103, 11, 0} ,
	{shader_103, 12, 0} ,
	{shader_104, 0, 0} ,
	{shader_104, 1, 0} ,
	{shader_104, 2, 0} ,
	{shader_104, 3, 0} ,
	{shader_104, 4, 0} ,
	{shader_104, 5, 0} ,
	{shader_104, 6, 0} ,
	{shader_104, 8, 0} ,
	{shader_104, 9, 0} ,
	{shader_104, 10, 0} ,
	{shader_104, 11, 0} ,
	{shader_104, 12, 0} ,
	{shader_105, 0, 0} ,
	{shader_105, 1, 0} ,
	{shader_105, 2, 0} ,
	{shader_105, 3, 0} ,
	{shader_105, 4, 0} ,
	{shader_105, 5, 0} ,
	{shader_105, 6, 0} ,
	{shader_105, 8, 0} ,
	{shader_105, 9, 0} ,
	{shader_105, 10, 0} ,
	{shader_105, 11, 0} ,
	{shader_105, 12, 0} ,
	{shader_106, 0, 0} ,
	{shader_106, 1, 0} ,
	{shader_106, 2, 0} ,
	{shader_106, 3, 0} ,
	{shader_106, 4, 0} ,
	{shader_106, 5, 0} ,
	{shader_106, 6, 0} ,
	{shader_106, 8, 0} ,
	{shader_106, 9, 0} ,
	{shader_106, 10, 0} ,
	{shader_106, 11, 0} ,
	{shader_106, 12, 0} ,
	{shader_107, 0, 0} ,
	{shader_107, 1, 0} ,
	{shader_107, 2, 0} ,
	{shader_107, 3, 0} ,
	{shader_107, 4, 0} ,
	{shader_107, 5, 0} ,
	{shader_107, 6, 0} ,
	{shader_107, 8, 0} ,
	{shader_107, 9, 0} ,
	{shader_107, 10, 0} ,
	{shader_107, 11, 0} ,
	{shader_107, 12, 0} ,
	{shader_108, 0, 0} ,
	{shader_108, 1, 0} ,
	{shader_108, 2, 0} ,
	{shader_108, 3, 0} ,
	{shader_108, 4, 0} ,
	{shader_108, 5, 0} ,
	{shader_108, 6, 0} ,
	{shader_108, 8, 0} ,
	{shader_108, 9, 0} ,
	{shader_108, 10, 0} ,
	{shader_108, 11, 0} ,
	{shader_108, 12, 0} ,
	{shader_109, 0, 0} ,
	{shader_109, 1, 0} ,
	{shader_109, 2, 0} ,
	{shader_109, 3, 0} ,
	{shader_109, 4, 0} ,
	{shader_109, 5, 0} ,
	{shader_109, 6, 0} ,
	{shader_109, 8, 0} ,
	{shader_109, 9, 0} ,
	{shader_109, 10, 0} ,
	{shader_109, 11, 0} ,
	{shader_109, 12, 0} ,
	{shader_110, 0, 0} ,
	{shader_110, 1, 0} ,
	{shader_110, 2, 0} ,
	{shader_110, 3, 0} ,
	{shader_110, 4, 0} ,
	{shader_110, 5, 0} ,
	{shader_110, 6, 0} ,
	{shader_110, 8, 0} ,
	{shader_110, 9, 0} ,
	{shader_110, 10, 0} ,
	{shader_110, 11, 0} ,
	{shader_110, 12, 0} ,
	{shader_111, 0, 0} ,
	{shader_111, 1, 0} ,
	{shader_111, 2, 0} ,
	{shader_111, 3, 0} ,
	{shader_111, 4, 0} ,
	{shader_111, 5, 0} ,
	{shader_111, 6, 0} ,
	{shader_111, 8, 0} ,
	{shader_111, 9, 0} ,
	{shader_111, 10, 0} ,
	{shader_111, 11, 0} ,
	{shader_111, 12, 0} ,
	{shader_112, 0, 0} ,
	{shader_112, 1, 0} ,
	{shader_112, 2, 0} ,
	{shader_112, 3, 0} ,
	{shader_112, 4, 0} ,
	{shader_112, 5, 0} ,
	{shader_112, 6, 0} ,
	{shader_112, 8, 0} ,
	{shader_112, 9, 0} ,
	{shader_112, 10, 0} ,
	{shader_112, 11, 0} ,
	{shader_112, 12, 0} ,
	{shader_113, 0, 0} ,
	{shader_113, 1, 0} ,
	{shader_113, 2, 0} ,
	{shader_113, 3, 0} ,
	{shader_113, 4, 0} ,
	{shader_113, 5, 0} ,
	{shader_113, 6, 0} ,
	{shader_113, 8, 0} ,
	{shader_113, 9, 0} ,
	{shader_113, 10, 0} ,
	{shader_113, 11, 0} ,
	{shader_113, 12, 0} ,
	{shader_114, 0, 0} ,
	{shader_114, 1, 0} ,
	{shader_114, 2, 0} ,
	{shader_114, 3, 0} ,
	{shader_114, 4, 0} ,
	{shader_114, 5, 0} ,
	{shader_114, 6, 0} ,
	{shader_114, 8, 0} ,
	{shader_114, 9, 0} ,
	{shader_114, 10, 0} ,
	{shader_114, 11, 0} ,
	{shader_114, 12, 0} ,
	{shader_115, 0, 0} ,
	{shader_115, 1, 0} ,
	{shader_115, 2, 0} ,
	{shader_115, 3, 0} ,
	{shader_115, 4, 0} ,
	{shader_115, 5, 0} ,
	{shader_115, 6, 0} ,
	{shader_115, 7, 0} ,
	{shader_115, 8, 0} ,
	{shader_115, 9, 0} ,
	{shader_115, 10, 0} ,
	{shader_115, 11, 0} ,
	{shader_115, 12, 0} ,
	{shader_116, 0, 0} ,
	{shader_116, 3, 0} ,
	{shader_116, 4, 0} ,
	{shader_116, 5, 0} ,
	{shader_116, 6, 0} ,
	{shader_116, 8, 0} ,
	{shader_116, 9, 0} ,
	{shader_116, 10, 0} ,
	{shader_116, 11, 0} ,
	{shader_116, 12, 0} ,
	{shader_117, 0, 0} ,
	{shader_117, 3, 0} ,
	{shader_117, 4, 0} ,
	{shader_117, 5, 0} ,
	{shader_117, 6, 0} ,
	{shader_117, 7, 0} ,
	{shader_117, 8, 0} ,
	{shader_117, 9, 0} ,
	{shader_117, 10, 0} ,
	{shader_117, 11, 0} ,
	{shader_117, 12, 0} ,
	{shader_118, 0, 0} ,
	{shader_118, 3, 0} ,
	{shader_118, 4, 0} ,
	{shader_118, 5, 0} ,
	{shader_118, 6, 0} ,
	{shader_118, 8, 0} ,
	{shader_118, 9, 0} ,
	{shader_118, 10, 0} ,
	{shader_118, 11, 0} ,
	{shader_118, 12, 0} ,
	{shader_119, 0, 0} ,
	{shader_119, 3, 0} ,
	{shader_119, 4, 0} ,
	{shader_119, 5, 0} ,
	{shader_119, 6, 0} ,
	{shader_119, 7, 0} ,
	{shader_119, 8, 0} ,
	{shader_119, 9, 0} ,
	{shader_119, 10, 0} ,
	{shader_119, 11, 0} ,
	{shader_119, 12, 0} ,
	{shader_120, 0, 0} ,
	{shader_120, 3, 0} ,
	{shader_120, 4, 0} ,
	{shader_120, 5, 0} ,
	{shader_120, 6, 0} ,
	{shader_120, 7, 0} ,
	{shader_120, 8, 0} ,
	{shader_120, 9, 0} ,
	{shader_120, 10, 0} ,
	{shader_120, 11, 0} ,
	{shader_120, 12, 0} ,
	{shader_121, 0, 0} ,
	{shader_121, 3, 0} ,
	{shader_121, 4, 0} ,
	{shader_121, 5, 0} ,
	{shader_121, 6, 0} ,
	{shader_121, 7, 0} ,
	{shader_121, 8, 0} ,
	{shader_121, 9, 0} ,
	{shader_121, 10, 0} ,
	{shader_121, 11, 0} ,
	{shader_121, 12, 0} ,
	{shader_122, 0, 0} ,
	{shader_122, 3, 0} ,
	{shader_122, 4, 0} ,
	{shader_122, 5, 0} ,
	{shader_122, 6, 0} ,
	{shader_122, 7, 0} ,
	{shader_122, 8, 0} ,
	{shader_122, 9, 0} ,
	{shader_122, 10, 0} ,
	{shader_122, 11, 0} ,
	{shader_122, 12, 0} ,
	{shader_123, 0, 0} ,
	{shader_123, 3, 0} ,
	{shader_123, 4, 0} ,
	{shader_123, 5, 0} ,
	{shader_123, 6, 0} ,
	{shader_123, 7, 0} ,
	{shader_123, 8, 0} ,
	{shader_123, 9, 0} ,
	{shader_123, 10, 0} ,
	{shader_123, 11, 0} ,
	{shader_123, 12, 0} ,
	{shader_124, 0, 0} ,
	{shader_124, 3, 0} ,
	{shader_124, 4, 0} ,
	{shader_124, 5, 0} ,
	{shader_124, 6, 0} ,
	{shader_124, 7, 0} ,
	{shader_124, 8, 0} ,
	{shader_124, 9, 0} ,
	{shader_124, 10, 0} ,
	{shader_124, 11, 0} ,
	{shader_124, 12, 0} ,
	{shader_125, 0, 0} ,
	{shader_125, 3, 0} ,
	{shader_125, 4, 0} ,
	{shader_125, 5, 0} ,
	{shader_125, 6, 0} ,
	{shader_125, 7, 0} ,
	{shader_126, 0, 0} ,
	{shader_126, 3, 0} ,
	{shader_126, 4, 0} ,
	{shader_126, 5, 0} ,
	{shader_126, 6, 0} ,
	{shader_126, 7, 0} ,
	{shader_127, 3, 0} ,
	{shader_127, 5, 0} ,
	{shader_128, 3, 0} ,
	{shader_128, 7, 0} ,
	{shader_129, 0, 0} ,
	{shader_129, 1, 0} ,
	{shader_129, 2, 0} ,
	{shader_129, 3, 0} ,
	{shader_129, 4, 0} ,
	{shader_129, 5, 0} ,
	{shader_129, 6, 0} ,
	{shader_129, 8, 0} ,
	{shader_129, 9, 0} ,
	{shader_129, 10, 0} ,
	{shader_129, 11, 0} ,
	{shader_129, 12, 0} ,
	{shader_130, 0, 0} ,
	{shader_131, 0, 0} ,
	{shader_132, 0, 0} ,
	{shader_133, 0, 0} ,
	{shader_134, 0, 0} ,
	{shader_135, 0, 0} ,
	{shader_136, 0, 0} ,
	{shader_137, 0, 0} ,
	{shader_138, 0, 0} ,
	{shader_139, 0, 0} ,
	{shader_140, 0, 0} ,
	{shader_141, 0, 0} ,
	{shader_142, 0, 0} ,
	{shader_143, 0, 0} ,
	{shader_144, 0, 0} ,
	{shader_145, 0, 0} ,
	{shader_146, 0, 0} ,
	{shader_147, 0, 0} ,
	{shader_148, 0, 0} ,
	{shader_149, 0, 0} ,
	{shader_150, 0, 0} ,
	{shader_151, 0, 0} ,
	{shader_152, 0, 0} ,
	{shader_153, 0, 0} ,
	{shader_154, 0, 0} ,
	{shader_155, 1, 0} ,
	{shader_155, 2, 0} ,
	{shader_155, 3, 0} ,
	{shader_156, 1, 0} ,
	{shader_156, 2, 0} ,
	{shader_156, 3, 0} ,
	{shader_157, 4, 0} ,
	{shader_157, 8, 0} ,
	{shader_157, 16, 0} ,
	{shader_158, 4, 0} ,
	{shader_158, 8, 0} ,
	{shader_158, 16, 0} ,
	{shader_182, 16, 0} ,
	{shader_183, 16, 0} ,
};


int shader_get_cnt()
{
	return sizeof(shader_tab)/sizeof(shader_tab[0]) + 1;
}

void shader_shade_pixmap(prop, pixmap, gc , w ,h, progr, rinfo, rgbbuf)
prop_t *prop;
GdkPixmap *pixmap;
GdkGC *gc;
gint w;
gint h;
gint progr;
randshader_info *rinfo;
absimg_rgb_t *rgbbuf;
{
	int i,j;
	guchar *lnbuf;
	guchar r0,r1,g0,g1,b0,b1;
	int type;
	gradient_t *gimpgrad = NULL;
	randshader_info *pinfo,sinfo;
	absimg_rgb_t *tile = NULL;

	if (!prop->shade && !rgbbuf && !prop->use_tiles) return;

	if (rinfo && !rinfo->load)
	{
		memset(rinfo, '\0', sizeof(randshader_info));
	}

	if (prop->tile && prop->use_tiles)
	{
		absimg_image_t *img;
		char *p;

		p = prop->tile;

		if ((!strcmp(p, gettext("Random")) ||
		     !strcasecmp(p, "random")) &&
		    cfg.tiles)
		{
			int n = g_list_length(cfg.tiles);

			n = chbg_rand()%n;

			p = (char *)(g_list_nth(cfg.tiles, n))->data;
		}

		if (p)
		{
			img = absimg_load(p);

			if (img)
			{
				tile = absimg_to_rgb(img);

				if (rinfo && !rinfo->load)
				{
					rinfo->tile = g_strdup(p);
				}
			}
			absimg_destroy(img);
		}
	}

	if (progr)
	{
		chbg_status_what(gettext("Generating background shading effect"), 0);
		chbg_status_progress(0,1);
	}

	if (rinfo && rinfo->load && (rinfo->gradnr > 0))
	{
		gimpgrad = (gradient_t *) (g_slist_nth(cfg.grads, rinfo->gradnr - 1))->data;
	}
	else if (!(rinfo && rinfo->load) && cfg.grads && prop->use_grad)
	{
		if (prop->gradnr)
		{
			GSList *ptr = g_slist_nth(cfg.grads, prop->gradnr-1);

			if (ptr)
				gimpgrad = (gradient_t *)ptr->data;
			else
				gimpgrad = (gradient_t *)cfg.grads->data;
		}
		else
			gimpgrad = grad_get_random();

		if (gimpgrad && rinfo)
		{
			rinfo->gradnr = g_slist_position(cfg.grads,
				g_slist_find(cfg.grads, gimpgrad)) + 1;
		}
	}

	if (rinfo && rinfo->load)
	{
		r0 = rinfo->r0;
		g0 = rinfo->g0;
		b0 = rinfo->b0;

		r1 = rinfo->r1;
		g1 = rinfo->g1;
		b1 = rinfo->b1;
	}
	else
	{
		r0 = prop->background.red/256 ;
		g0 = prop->background.green/256;
		b0 = prop->background.blue/256;

		r1 = prop->background2.red/256 ;
		g1 = prop->background2.green/256;
		b1 = prop->background2.blue/256;
	}

	if (rinfo)
	{
		rinfo->r0 = r0;
		rinfo->g0 = g0;
		rinfo->b0 = b0;

		rinfo->r1 = r1;
		rinfo->g1 = g1;
		rinfo->b1 = b1;
	}

	lnbuf = g_malloc(3 * w);

	if (prop->shade == 1)
	{
		GSList *ptr = cfg.d_shaders;
		i = shader_get_cnt();
		while(ptr)
		{
			if (((int)ptr->data) < shader_get_cnt())
				i--;
			ptr = ptr->next;
		}
		type = 2 + (int)((float)(i-2)*(float)chbg_rand()/(RAND_MAX + 1.0));

		if (cfg.d_shaders)
		{
			for(i = 1, j = 0; i < shader_get_cnt(); i++)
			{
				if (!g_slist_find(cfg.d_shaders, (gpointer)i))
				{
					j++;
					if (j == type)
						break;
				}
			}
			type = i;
		}
	}
	else
		type = prop->shade;

	if (rinfo)
		pinfo = rinfo;
	else
	{
		pinfo = &sinfo;
		pinfo->r0 = r0;
		pinfo->g0 = g0;
		pinfo->b0 = b0;

		pinfo->r1 = r1;
		pinfo->g1 = g1;
		pinfo->b1 = b1;

		pinfo->shadernr = type;
		pinfo->gradnr = 0;
	}

	if (!type && !tile && rgbbuf)
	{
		absimg_rgb_fill(rgbbuf, r0, g0, b0);
	}
	else if (!type)
	{
		shader_noop(pixmap, gc, progr, pinfo, gimpgrad, lnbuf, w, h, 0, 0, rgbbuf, tile);
	}
	else
		shader_tab[type-2].func(pixmap, gc, progr, pinfo, gimpgrad, lnbuf, w, h, shader_tab[type-2].par1, shader_tab[type-2].par2, rgbbuf, tile);

	if (progr)
		chbg_status_progress(0,1);

	g_free(lnbuf);

	absimg_rgb_free(tile);
}

#define FINISH_LINE \
	if (pixmap) \
		gdk_draw_rgb_image(pixmap , gc , 0 , y , w , 1 ,\
			GDK_RGB_DITHER_NORMAL, lnbuf, 0);\
	if (rgbbuf) \
		memcpy(rgbbuf->rgb + 3*w*y, lnbuf, w*3); \
	if (progr)\
	{\
		chbg_status_progress(y,h);\
		ServeEvents\
	}

#define FINISH_POINT(factor) \
	if (factor > 1.0)\
		printf("[%d] overflow (%f) at %dx%d\n", rinfo->shadernr, factor, x ,y);\
	if (factor < 0.0)\
		printf("[%d] underflow (%f) at %dx%d\n", rinfo->shadernr, factor, x, y);\
	if (tile) \
	{ \
		unsigned char *p = tile->rgb + 3 * (x % tile->width) + \
			3 * tile->width * (y % tile->height); \
		r = (guchar) ((double)p[0] * factor) + \
			((double)rinfo->r0 * (1.0 - factor)); \
		g = (guchar) ((double)p[1] * factor) + \
			((double)rinfo->g0 * (1.0 - factor)); \
		b = (guchar) ((double)p[2] * factor) + \
			((double)rinfo->b0 * (1.0 - factor)); \
	} \
	else if (gimpgrad)\
	{\
		double gr,gg,gb;\
		grad_get_color_at(gimpgrad, factor, &gr, &gg, &gb);\
		r = (guchar) (255.0 * gr);\
		g = (guchar) (255.0 * gg);\
		b = (guchar) (255.0 * gb);\
	}\
	else\
	{\
		r = rinfo->r0 + (guchar)((double)(rinfo->r1 - rinfo->r0) * factor);\
		g = rinfo->g0 + (guchar)((double)(rinfo->g1 - rinfo->g0) * factor);\
		b = rinfo->b0 + (guchar)((double)(rinfo->b1 - rinfo->b0) * factor);\
	}\
	p[0] = r; p[1] = g; p[2] = b;\
	p += 3;


/*******************************
 * pattern for shader function *
 ***************************** */
#define SHADER(name) \
static void shader_##name(pixmap, gc, progr, rinfo, gimpgrad, lnbuf, w, h, par1, par2, rgbbuf, tile) \
GdkPixmap *pixmap; \
GdkGC *gc; \
int progr; \
randshader_info *rinfo; \
gradient_t *gimpgrad; \
guchar *lnbuf; \
int w; \
int h; \
int par1; \
int par2; \
absimg_rgb_t * rgbbuf; \
absimg_rgb_t *tile; \
{ \
	guchar r,g,b; \
	int x,y; \
	guchar *p; \
	double factor; \
	SHADER_VAR \
	for (y = 0 ; y < h ; y++) \
	{ \
		p = lnbuf; \
		for (x = 0 ; x < w ; x++) \
		{ \
			SHADER_FACTOR \
			FINISH_POINT(factor); \
		} \
		SHADER_LINE \
		FINISH_LINE \
	} \
}


#define SHADER_VAR
#define SHADER_LINE
#define SHADER_FACTOR factor = 1.0;
SHADER(noop)


#undef SHADER_FACTOR
#define SHADER_FACTOR factor = (double)x/(double)w;
SHADER(2)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)x/(double)w - 1.0; \
	factor = sqrt(1.0 - factor * factor);
SHADER(3)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)x/(double)w; \
	factor = 1.0 - sqrt(1.0 - factor * factor);
SHADER(4)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)x/(double)w; \
	factor = (sin((-M_PI / 2.0) + M_PI * factor) + 1.0)/2.0;
SHADER(5)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)x/(double)w; \
	factor = sin(M_PI * factor);
SHADER(6)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = (double)y/(double)h;
SHADER(7)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)y/(double)h - 1.0; \
	factor = sqrt(1.0 - factor * factor);
SHADER(8)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)y/(double)h; \
	factor = 1.0 - sqrt(1.0 - factor * factor);
SHADER(9)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)y/(double)h; \
	factor = (sin((-M_PI / 2.0) + M_PI * factor) + 1.0)/2.0;
SHADER(10)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)y/(double)h; \
	factor = sin(M_PI * factor);
SHADER(11)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = sqrt((double)(x*y))/sqrt((double)(w*h));
SHADER(12)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = sqrt((double)((w-x)*(h-y)))/sqrt((double)(w*h));
SHADER(13)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = sqrt((double)((w-x)*(y)))/sqrt((double)(w*h));
SHADER(14)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = sqrt((double)((x)*(h-y)))/sqrt((double)(w*h));
SHADER(15)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
SHADER(16)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*h));
SHADER(17)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = 2.0 * sqrt((double)(abs(h/2-y)*abs(w/2-x)))/sqrt((double)(w*h));
SHADER(18)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2+1-y)*(h/2+1-y)-(w/2+1-x)*(w/2+1-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(4 * M_PI * factor))/2.0;
SHADER(19)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4+h*h/4)); \
	factor = (factor - factor * sin(8 * M_PI * factor))/2.0;
SHADER(20)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(21)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = 1.0 - factor; \
	factor = (factor - factor * sin(16 * M_PI * (1.0 - factor)))/2.0;
SHADER(22)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4 - x*x/4 - y*y/4))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(23)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4 - (w-x)*(w-x)/4 - (h-y)*(h-y)/4))/sqrt((double)(w*w/4+h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(24)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(25)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)x/(double)w; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(26)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)y/(double)h; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(27)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = (double)(y+x)/(double)(h+w);
SHADER(28)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = (double)((w-x)+y)/(double)(h+w);
SHADER(29)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)(y+x)/(double)(h+w); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(30)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)((w-x)+y)/(double)(h+w); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(31)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * (double)x/(double)w))/2.0;
SHADER(32)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * (double)x/(double)w))/2.0;
SHADER(33)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)(y+x)/(double)(h+w); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor *= (double)((w-x)+y)/(double)(h+w);
SHADER(34)

#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)(y+x)/(double)(h+w); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)((w-x)+y)/(double)(h+w); \
	factor2 = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(35)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)(y+x)/(double)(h+w); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)((w-x)+y)/(double)(h+w); \
	factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(36)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)x/(double)w; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)y/(double)h; \
	factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(37)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)y/(double)h; \
	factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(38)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)x/(double)w; \
	factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(39)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor2 = (1.0 + sin(16 * M_PI * (double)x/(double)w))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(40)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor2 = (1.0 + sin(16 * M_PI * (double)y/(double)h))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(41)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor2 = (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(42)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor2 = (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(43)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor2 = (1.0 + sin(16 * M_PI * (double)y/(double)h))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(44)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor2 = (1.0 + sin(16 * M_PI * (double)x/(double)w))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(45)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)x/(double)w; \
	factor = (1.0 + sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)y/(double)h; \
	factor2 = (1.0 + sin(16 * M_PI * factor2))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(46)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)(y+x)/(double)(h+w); \
	factor = (1.0 + sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)((w-x)+y)/(double)(h+w); \
	factor2 = (1.0 + sin(16 * M_PI * factor2))/2.0; \
	factor = (factor + factor2)/2.0;
SHADER(47)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)(y+x)/(double)(h+w); \
	factor = (1.0 + sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)((w-x)+y)/(double)(h+w); \
	factor2 = (1.0 + sin(16 * M_PI * factor2))/2.0; \
	factor = (factor + factor2)/2.0; \
	factor2 = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor + factor2)/2.0;
SHADER(48)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)(y+x)/(double)(h+w); \
	factor = (1.0 + sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)((w-x)+y)/(double)(h+w); \
	factor2 = (1.0 + sin(16 * M_PI * factor2))/2.0; \
	factor = (factor + factor2)/2.0; \
	factor2 = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*h)); \
	factor = (factor + factor2)/2.0;
SHADER(49)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double)(y+x)/(double)(h+w); \
	factor = (1.0 + sin(16 * M_PI * factor))/2.0; \
	factor2 = (double)((w-x)+y)/(double)(h+w); \
	factor *= (1.0 + sin(16 * M_PI * factor2))/2.0;
SHADER(50)

#undef SHADER_VAR
#define SHADER_VAR
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (1.0 + sin(16 * M_PI * (double)x/(double)w))/2.0; \
	factor *= (1.0 + sin(16 * M_PI * (double)y/(double)h))/2.0;
SHADER(51)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor *= (1.0 + sin(16 * M_PI * (double)y/(double)h))/2.0;
SHADER(52)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor *= (1.0 + sin(16 * M_PI * (double)x/(double)w))/2.0;
SHADER(53)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
SHADER(54)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0;
SHADER(55)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
SHADER(56)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)(y+x)/(double)(h+w)))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0;
SHADER(57)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
SHADER(58)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(32 * M_PI * factor))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)(y+x)/(double)(h+w)))/2.0; \
	factor *= (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0;
SHADER(59)

#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (1.0 + sin(32 * M_PI * (double)(x+y)/(double)(w+h)))/2.0; \
	factor += (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0; \
	factor2 = (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0; \
	factor2 += (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0; \
	factor = (factor * factor2)/4.0;
SHADER(60)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (1.0 + sin(32 * M_PI * (double)(x+y)/(double)(w+h)))/2.0; \
	factor += (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0; \
	factor2 = (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0; \
	factor2 += (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0; \
	factor = (factor * factor2)/4.0; \
	factor2 = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor *= (factor2 - factor2 * sin(32 * M_PI * factor2))/2.0;
SHADER(61)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (1.0 + sin(32 * M_PI * (double)(x+y)/(double)(w+h)))/2.0; \
	factor += (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0; \
	factor2 = (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0; \
	factor2 += (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0; \
	factor = (factor * factor2)/4.0; \
	factor2 = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor *= (factor2 - factor2 * sin(32 * M_PI * factor2))/2.0;
SHADER(62)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI; \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor *= factor2;
SHADER(63)

#undef SHADER_VAR
#define SHADER_VAR
#undef SHADER_FACTOR
#define SHADER_FACTOR factor = 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI;
SHADER(64)

#undef SHADER_FACTOR
#define SHADER_FACTOR factor = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI);
SHADER(65)

#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor *= factor2;
SHADER(66)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor *= factor2; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(67)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = 1.01 - (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor *= factor2; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(68)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI; \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor *= factor2; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(69)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = 1.0 - 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI; \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor *= factor2; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(70)

#undef SHADER_VAR
#define SHADER_VAR
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(71)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(72)

#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor2 = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor = 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor *= factor2;
SHADER(73)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
{ \
	double fx,fy; \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	fy = ((double)h)/2.0-(factor2*(float)y); \
	fx = ((double)w)/2.0-(factor2*(float)x); \
	factor = sqrt((double)(fy*fy+fx*fx))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
}
SHADER(74)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
{ \
	double fx,fy; \
	factor2 = 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI; \
	fy = ((double)h)/2.0-(factor2*(float)y); \
	fx = ((double)w)/2.0-(factor2*(float)x); \
	factor = sqrt((double)(fy*fy+fx*fx))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
}
SHADER(75)

#undef SHADER_VAR
#define SHADER_VAR \
	double factor2; \
	struct {int x; int y;} plasma[10]; \
	int i; \
	for (i = 0; i < sizeof(plasma)/sizeof(*plasma); i++) \
	{ \
		plasma[i].x = chbg_rand()%w; \
		plasma[i].y = chbg_rand()%h; \
	}
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = 0.0; \
	for (i = 0; i < sizeof(plasma)/sizeof(*plasma); i++) \
	{ \
		factor2 = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/(double)MIN(w,h); \
		if (factor2 > 1.0) factor2 = 1/factor2; \
		factor2 = (factor2 - factor2 * sin(8 * M_PI * factor2))/2.0; \
		factor += factor2; \
	} \
	factor = factor/(double)(sizeof(plasma)/sizeof(*plasma));
SHADER(76)

#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sqrt((double)((h/8-y%4)*(h/8-y%4)+(w/8-x%4)*(w/8-x%4)))/sqrt((double)(w*w/64 + h*h/64)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor2 = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0; \
	factor *= factor2;
SHADER(77)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/64 + h*h/64)); \
	factor = factor - floor(factor); \
	factor *= factor2; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
SHADER(78)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/64 + h*h/64)); \
	factor = factor - floor(factor); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor *= factor2;
SHADER(79)

#undef SHADER_VAR
#define SHADER_VAR double factor2,fx,fy;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	fy = (double)(h/2)-factor2*(double)y; \
	fx = (double)(w/2)-factor2*(double)x; \
	factor = sqrt((double)(fy*fy+fx*fx))/sqrt((double)(w*w/64 + h*h/64)); \
	factor *= factor2; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor /= 4.0;
SHADER(80)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	fy = (double)(h/2-y) + factor2*(double)y; \
	fx = (double)(w/2-x) + factor2*(double)x; \
	factor = sqrt((double)(fy*fy+fx*fx))/sqrt((double)(w*w/64 + h*h/64)); \
	factor *= factor2; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor /= 4.0;
SHADER(81)

#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor2 = (factor + factor2)/2.0; \
	factor = (sin(32 * M_PI * factor2) + 1.0)/2.0;
SHADER(82)




#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h-y)*(h-y)+(w-x)*(w-x)))/sqrt((double)(w*w + h*h)); \
	factor2 = (factor + factor2)/2.0; \
	factor = (sin(32 * M_PI * factor2) + 1.0)/2.0;
SHADER(182)

#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w-x), (double)(h-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h-y)*(h-y)+(w-x)*(w-x)))/sqrt((double)(w*w + h*h)); \
	factor2 = (factor + factor2)/2.0; \
	factor = (sin(32 * M_PI * factor2) + 1.0)/2.0;
SHADER(183)





#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor2 = (factor + factor2)/2.0; \
	factor2 = (sin(32 * M_PI * factor2) + 1.0)/2.0; \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
	factor *= factor2;
SHADER(83)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	factor2 *= factor; \
	factor = (sin(32 * M_PI * factor2) + 1.0)/2.0;
SHADER(84)

#undef SHADER_VAR
#define SHADER_VAR
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sin((double)(x+y)/4)*sin((double)(y+w-x)/4); \
	factor = factor - floor(factor);
SHADER(85)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sin((double)(x+y)/32)*sin((double)(y+w-x)/16); \
	factor = factor - floor(factor);
SHADER(86)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = sin(16*M_PI*(double)(x+y)/w)*atan2((double)y,(double)x)+M_PI; \
	factor /= 2*M_PI;
SHADER(87)

#undef SHADER_VAR
#define SHADER_VAR double factor2;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
{ \
	double fy; \
	factor2 = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	fy = ((double)h)/2.0-(factor2*(float)y); \
	factor = sqrt((double)(fy*fy))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
}
SHADER(88)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
{ \
	double fy; \
	factor2 = 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI; \
	fy = ((double)h)/2.0-(factor2*(float)y); \
	factor = sqrt((double)(fy*fy))/sqrt((double)(w*w/4 + h*h/4)); \
	factor = (factor - factor * sin(16 * M_PI * factor))/2.0; \
}
SHADER(89)




#define SHADER_FRACT_FACTOR \
	switch (par1) \
	{ \
		case 0: \
			factor = ((double)n)/(double)cfg.fract_iter; \
		break; \
		case 1: \
			if (zi == 0.0) \
				factor = 1.0; \
			else \
				factor = fabs(zr/zi); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 2: \
			if (zi == 0.0) \
				factor = 1.0; \
			else \
				factor = fabs(zr/zi); \
			factor = factor - floor(factor); \
		break; \
		case 3: \
			factor = fabs(((double)n)/(double)cfg.fract_iter + cr); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 4: \
			factor = fabs(((double)n)/(double)cfg.fract_iter + zr); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 5: \
			factor = fabs(((double)n)/(double)cfg.fract_iter + zr/zi); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 6: \
			factor = fabs(((double)n)/(double)cfg.fract_iter + zr + zi + zr/zi); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 7: \
			if (ci == 0.0) \
				factor = 1.0; \
			else \
				factor = fabs(cr/ci); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 8: \
			factor = fabs(((double)n)/(double)cfg.fract_iter + sin(zr*zr - zi*zi)); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 9: \
			factor = fabs(((double)n)/(double)cfg.fract_iter + atan(zr*zi)); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 10: \
			factor = fabs(((double)n)/(double)cfg.fract_iter + atan2(zr,zi)); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 11: \
			factor = fabs(((double)n)/(double)cfg.fract_iter + (zr*zr + zi*zi) * cos(zr*zr)); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		case 12: \
			factor = fabs(((double)n)/(double)cfg.fract_iter * (zr*zr + zi*zi)); \
			if (factor > 1.0) \
				factor = 1.0/factor; \
		break; \
		default: \
			factor = ((double)n)/(double)cfg.fract_iter; \
		break; \
	} \


#undef SHADER_VAR
#define SHADER_VAR \
	int n; \
	double zr,zi,tz,cr,ci;\
	ci = cr = -2.0;
#undef SHADER_LINE
#define SHADER_LINE \
	cr = -2.0; \
	ci += 4.0 / (double)h;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		zi = 2*zr*zi + ci; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(90)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + ci; \
		zi = 2*zr*zi + cr; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(91)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + ci; \
		zr = 2*zr*zi + cr; \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(92)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		zr = 2*zr*zi + ci; \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(93)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr - 3*zi*zi*zr + cr; \
		zi = -zi*zi*zi + 3*zr*zr*zi + ci; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(94)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi + cr; \
		zi = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + ci; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr*zr*zr + zi*zi*zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(95)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi + cr; \
		zr = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + ci; \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr*zr*zr + zi*zi*zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(96)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr - 3*zi*zi*zr + cr; \
		zr = -zi*zi*zi + 3*zr*zr*zi + ci; \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(97)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = 5*zi*zi*zi*zi*zr - 10*zi*zi*zr*zr*zr + zr*zr*zr*zr*zr + cr; \
		zi = zi*zi*zi*zi*zi - 10*zi*zi*zi*zr*zr + 5*zi*zr*zr*zr*zr + ci; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(98)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = 5*zi*zi*zi*zi*zr - 10*zi*zi*zr*zr*zr + zr*zr*zr*zr*zr + cr; \
		zr = zi*zi*zi*zi*zi - 10*zi*zi*zi*zr*zr + 5*zi*zr*zr*zr*zr + ci; \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(99)

/* JULIA */
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = cr; zi = ci; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi - 0.75; \
		zi = 2*zr*zi + 0.35; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(100)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = cr; zi = ci; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi - 0.35; \
		zr = 2*zr*zi + 0.75; \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(101)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = cr; zi = ci; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr - 3*zi*zi*zr - 0.68; \
		zi = -zi*zi*zi + 3*zr*zr*zi - 0.412; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(102)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = cr; zi = ci; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr - 3*zi*zi*zr - 0.68; \
		zr = -zi*zi*zi + 3*zr*zr*zi - 0.412; \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(103)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = cr; zi = ci; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi + 0.3; \
		zi = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + 0.6; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr*zr*zr + zi*zi*zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(104)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = cr; zi = ci; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi - 0.08; \
		zr = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + 0.08; \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr*zr*zr + zi*zi*zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(105)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr/(ci*ci + cr*cr); \
		zi = 2*zr*zi - ci/(cr*cr + ci*ci); \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(106)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr/(ci*ci + cr*cr); \
		zr = 2*zr*zi - ci/(cr*cr + ci*ci); \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(107)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr - 3*zi*zi*zr + cr/(ci*ci + cr*cr);; \
		zi = -zi*zi*zi + 3*zr*zr*zi + ci/(cr*cr + ci*ci); \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(108)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr - 3*zi*zi*zr + cr/(ci*ci + cr*cr);; \
		zr = -zi*zi*zi + 3*zr*zr*zi + ci/(cr*cr + ci*ci); \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(109)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi + cr/(cr*cr + ci*ci); \
		zi = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + ci/(cr*cr + ci*ci); \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr*zr*zr + zi*zi*zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(110)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi + cr/(cr*cr + ci*ci); \
		zr = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + ci/(cr*cr + ci*ci); \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr*zr*zr + zi*zi*zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(111)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = 5*zi*zi*zi*zi*zr - 10*zi*zi*zr*zr*zr + zr*zr*zr*zr*zr + cr/(cr*cr + ci*ci); \
		zi = zi*zi*zi*zi*zi - 10*zi*zi*zi*zr*zr + 5*zi*zr*zr*zr*zr + ci/(cr*cr + ci*ci); \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(112)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = 5*zi*zi*zi*zi*zr - 10*zi*zi*zr*zr*zr + zr*zr*zr*zr*zr + cr/(cr*cr + ci*ci); \
		zr = zi*zi*zi*zi*zi - 10*zi*zi*zi*zr*zr + 5*zi*zr*zr*zr*zr + ci/(cr*cr + ci*ci); \
		zi = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(113)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = zi = 0.0; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		zi = 2*zr*zi + ci; \
		zr = tz; \
	} while((n < cfg.fract_iter) && (exp(zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(114)


#undef SHADER_VAR
#define SHADER_VAR \
	int n; \
	double zr,zi,tz,cr,ci,scr,sci;\
	ci = cr = -2.0;
#undef SHADER_LINE
#define SHADER_LINE \
	cr = -2.0; \
	ci += 4.0 / (double)h;
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		ci = 2*zr*zi + ci; \
		cr = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(115)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		ci = 2*zr*zi + ci; \
		cr = tz; \
	} while((n < cfg.fract_iter) && ((sin(cr*ci)*(ci+cr)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(116)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		cr = 2*zr*zi + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(117)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		cr = 2*zr*zi + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((sin(cr*ci)*(ci+cr)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(118)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi + cr; \
		ci = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + ci; \
		cr = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(119)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi + cr; \
		cr = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(120)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = 5*zi*zi*zi*zi*zr - 10*zi*zi*zr*zr*zr + zr*zr*zr*zr*zr + cr; \
		cr = zi*zi*zi*zi*zi - 10*zi*zi*zi*zr*zr + 5*zi*zr*zr*zr*zr + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*cr+ci*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(121)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr - 3*zi*zi*zr + cr; \
		cr = -zi*zi*zi + 3*zr*zr*zi + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(122)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr - 3*zi*zi*zr + cr; \
		ci = -zi*zi*zi + 3*zr*zr*zi + ci; \
		cr = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(123)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		cr = 2*zr*zi + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*cr+ci*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(124)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; cr = 0; ci = 0; \
	do \
	{ \
		n++; \
		tz = 5*zi*zi*zi*zi*zr - 10*zi*zi*zr*zr*zr + zr*zr*zr*zr*zr + cr; \
		cr = zi*zi*zi*zi*zi - 10*zi*zi*zi*zr*zr + 5*zi*zr*zr*zr*zr + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*cr+ci*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(125)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; \
	do \
	{ \
		n++; \
		tz = 5*zi*zi*zi*zi*zr - 10*zi*zi*zr*zr*zr + zr*zr*zr*zr*zr + cr; \
		cr = zi*zi*zi*zi*zi - 10*zi*zi*zi*zr*zr + 5*zi*zr*zr*zr*zr + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*cr+ci*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(126)


#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + cr; \
		ci = 2*zr*zi + ci; \
		cr = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(127)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	n = -1; zr = scr = cr; zi = sci = ci; \
	do \
	{ \
		n++; \
		tz = zr*zr*zr*zr + zi*zi*zi*zi - 4*zr*zr*zi*zi + cr; \
		cr = 2*zr*zr*zr*zi -2*zi*zi*zi*zr + ci; \
		ci = tz; \
	} while((n < cfg.fract_iter) && ((exp(cr*ci)) <= 4.0)); \
	SHADER_FRACT_FACTOR \
	cr = scr; ci = sci; cr += 4.0 / (double)w;
SHADER(128)



#undef SHADER_VAR
#define SHADER_VAR \
	int n; \
	double zr,zi,tz,cr,ci,rr,ri;\
	ci = cr = -2.0;\
	rr = ((double)chbg_rand())/(double)(RAND_MAX/2) - 1.0; \
	ri = ((double)chbg_rand())/(double)(RAND_MAX/2) - 1.0; 
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	zr = cr; zi = ci; n = -1; \
	do \
	{ \
		n++; \
		tz = zr*zr - zi*zi + rr; \
		zi = 2*zr*zi + ri; \
		zr = tz; \
	} while((n < cfg.fract_iter) && ((zr*zr + zi*zi) <= 4.0)); \
	cr += 4.0 / (double)w; \
	SHADER_FRACT_FACTOR
SHADER(129)

#define PNUM	16

#undef SHADER_VAR
#define SHADER_VAR \
	struct {double x; double y;} plasma[PNUM]; \
	int perm[PNUM]; \
	int i; \
	for (i = 0; i < PNUM; i++) \
	{ \
		plasma[i].x = ((double)(chbg_rand()%w))/(double)(w); \
		plasma[i].y = ((double)(chbg_rand()%h))/(double)(h); \
	} \
	for (i = 0; i < PNUM; i++) perm[i] = i; \
	for (i = 0; i < PNUM; i++) \
	{ \
		int a,b,t; \
		a = chbg_rand () % PNUM; \
		b = chbg_rand () % PNUM; \
		t = perm[a]; \
		perm[a] = perm[b]; \
		perm[b] = t; \
	}
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i,n,s; \
		double sum = 0.0; \
		factor = 0.0; \
		for (s = 0; s < cfg.fract_iter ; s++) \
		{ \
			for (i = 0 ; i < 4; i++) \
			{ \
				n = perm[(x + i%2 + perm[(y + i/2) % PNUM]) % PNUM]; \
				sum += (plasma[n].x * (double)x/(double)w + plasma[n].y * (double)y/(double)h); \
			} \
			factor += sum/(double)(1 << s); \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
#undef SHADER_LINE
#define SHADER_LINE
SHADER(130)

#undef SHADER_VAR
#define SHADER_VAR \
	struct {int x; int y;} plasma[PNUM]; \
	int i; \
	for (i = 0; i < PNUM; i++) \
	{ \
		plasma[i].x = chbg_rand()%w; \
		plasma[i].y = chbg_rand()%h; \
	}
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tx,ty; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tx = ((double)(plasma[i].x - x))/(double)w; \
			tx *= tx; \
			ty = ((double)(plasma[i].y - y))/(double)h; \
			ty *= ty; \
			factor = MAX(sqrt(tx + ty), factor); \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(131)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0;\
			factor = MAX(tfactor, factor); \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(132)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = sqrt((double)(h*h/4+w*w/4-(plasma[i].y-y)*(plasma[i].y-y)-(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0; \
			factor = MAX(tfactor, factor); \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(133)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 1.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = sqrt((double)(h*h/4+w*w/4-(plasma[i].y-y)*(plasma[i].y-y)-(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0; \
			factor = MIN(tfactor, factor); \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(134)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor,factor2; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			factor2 = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			factor2 = (tfactor + factor2)/2.0; \
			tfactor = (sin(32 * M_PI * factor2) + 1.0)/2.0; \
			factor = MAX(tfactor, factor); \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(135)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor,factor2; \
		factor = 1.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			factor2 = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			factor2 = (tfactor + factor2)/2.0; \
			tfactor = (sin(32 * M_PI * factor2) + 1.0)/2.0; \
			factor = MIN(tfactor, factor); \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(136)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0;\
			factor = tfactor + factor/2; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(137)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor,factor2; \
		factor = 1.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			factor2 = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			factor2 = (tfactor + factor2)/2.0; \
			tfactor = (sin(32 * M_PI * factor2) + 1.0)/2.0; \
			factor = tfactor + factor/2; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(138)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 1.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = 2*atan2((double)abs(plasma[i].x-x), (double)abs(plasma[i].y-y))/M_PI; \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0; \
			factor = tfactor + factor/2; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(139)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = 2*atan2((double)abs(plasma[i].x-x), (double)abs(plasma[i].y-y))/M_PI; \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0; \
			factor = tfactor + factor/2; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(140)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = 2*atan2((double)abs(plasma[i].x-x), (double)abs(plasma[i].y-y))/M_PI; \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0; \
			factor = MAX(tfactor, factor); \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(141)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor,tfactor2; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor2 = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor2 *= tfactor; \
			tfactor = (sin(32 * M_PI * tfactor2) + 1.0)/2.0; \
			factor = tfactor + factor/2; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(142)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0; \
			factor = tfactor + factor/2; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(143)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = 0.5 + sin(16 * M_PI * tfactor)/2.0; \
			factor = tfactor + factor/2; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(144)


#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (atan2((double)(w/2-x), (double)(h/2-y)) + M_PI)/(2*M_PI); \
	factor = 0.5 + sin(32 * M_PI * factor)/2.0;
SHADER(145)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 1.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = 0.5 + sin(16 * M_PI * tfactor)/2.0; \
			factor = 2 * tfactor * factor; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(146)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 1.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0;\
			factor = 2 * tfactor * factor; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(147)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 1.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0;\
			factor = 8 * tfactor * factor; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(148)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0;\
			factor += tfactor/(gfloat)PNUM; \
		} \
	}
SHADER(149)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = 0.5 + sin(16 * M_PI * tfactor)/2.0; \
			factor += tfactor/(gfloat)PNUM; \
		} \
	}
SHADER(150)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0;\
			factor += tfactor/(gfloat)PNUM; \
		} \
	}
SHADER(151)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor,tfactor2; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor2 = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			tfactor2 *= tfactor; \
			tfactor = (sin(32 * M_PI * tfactor2) + 1.0)/2.0; \
			factor += tfactor/(gfloat)PNUM; \
		} \
		if (factor > 1.0) \
			factor = 1.0/factor; \
	}
SHADER(152)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			tfactor = 2*atan2((double)abs(plasma[i].x-x), (double)abs(plasma[i].y-y))/M_PI; \
			tfactor = (tfactor - tfactor * sin(16 * M_PI * tfactor))/2.0; \
			factor += tfactor/(gfloat)PNUM; \
		} \
	}
SHADER(153)

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	{ \
		int i; \
		double tfactor,factor2; \
		factor = 0.0; \
		for (i = 0 ; i < PNUM; i++) \
		{ \
			factor2 = (atan2((double)(plasma[i].x-x), (double)(plasma[i].y-y)) + M_PI)/(2*M_PI); \
			tfactor = sqrt((double)((plasma[i].y-y)*(plasma[i].y-y)+(plasma[i].x-x)*(plasma[i].x-x)))/sqrt((double)(w*w/4 + h*h/4)); \
			factor2 = (tfactor + factor2)/2.0; \
			tfactor = (sin(32 * M_PI * factor2) + 1.0)/2.0; \
			factor += tfactor/(gfloat)PNUM; \
		} \
	}
SHADER(154)


#undef SHADER_VAR
#define SHADER_VAR
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double) ((y / par1) % 2);
SHADER(155)

#undef SHADER_VAR
#define SHADER_VAR
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double) ((x / par1) % 2);
SHADER(156)

#undef SHADER_VAR
#define SHADER_VAR
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double) (((x / par1) % 2) * ((y / par1) % 2));
SHADER(157)

#undef SHADER_VAR
#define SHADER_VAR
#undef SHADER_FACTOR
#define SHADER_FACTOR \
	factor = (double) (((x / par1) % 2) == ((y / par1) % 2));
SHADER(158)






/******************************************************************************
 * experiment with self coloring effects
 *****************************************************************************/
#undef FINISH_POINT
#define FINISH_POINT(factor) \
	if (gimpgrad)\
	{\
		double gr,gg,gb;\
		grad_get_color_at(gimpgrad, fr, &gr, &gg, &gb);\
		r = (guchar) (255.0 * gr * fr);\
		g = (guchar) (255.0 * gg * fg);\
		b = (guchar) (255.0 * gb * fb);\
	}\
	else\
	{\
		r = rinfo->r0 + (guchar)((double)(rinfo->r1 - rinfo->r0) * fr);\
		g = rinfo->g0 + (guchar)((double)(rinfo->g1 - rinfo->g0) * fg);\
		b = rinfo->b0 + (guchar)((double)(rinfo->b1 - rinfo->b0) * fb);\
	}\
	p[0] = r; p[1] = g; p[2] = b;\
	p += 3;




#if 0
/*
 * experiment with colored shaders
 */
#undef SHADER_VAR
#define SHADER_VAR \
	double fr,fg,fb;

#undef SHADER_FACTOR
#define SHADER_FACTOR \
	fr = 2.0 * sqrt((double)(abs(h/2-y)*abs(w/2-x)))/sqrt((double)(w*h));\
	fg = (double)x/(double)w - 1.0; \
	fg = sqrt(1.0 - fg * fg); \
	fb = (double)x/(double)w; \
	fb = (sin((-M_PI / 2.0) + M_PI * fb) + 1.0)/2.0;
SHADER(200)


#undef SHADER_FACTOR
#define SHADER_FACTOR \
	fr = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4)); \
	fr = (fr - fr * sin(16 * M_PI * fr))/2.0; \
	fg = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4+h*h/4)); \
	fg = (fg - fg * sin(8 * M_PI * fg))/2.0; \
	fb = 2*atan2((double)abs(w/2-x), (double)abs(h/2-y))/M_PI;
SHADER(201)
#endif
