-----------------------------------------------------------------------------
-- CVS $Id: Main.hs,v 1.6 2003/03/03 11:29:26 obraun Exp $
-- CVS $Unsane: projects/checkrdf/Main.hs,v 1.6 2005/05/29 19:27:39 lizard Exp $
-- |
--
-- Module      : Main
-- Copyright   : (c) Oliver Braun 2002-2005
-- License     : BSD
--
-- Maintainer  : obraun@informatik.unibw-muenchen.de
-- Stability   : provisional
-- Portability : portable
--
--
-- ExitCode 0 means news were put, ExitCode 1 means no news or put to pending.
-----------------------------------------------------------------------------

module Main where

import CheckRDF
import RDFConfig
import System (getArgs, exitWith, ExitCode(..),getEnv)

main :: IO ()
main = do files <- getArgs
          putStr "."
          rawConfig <- getContents
          let maybeConfig = mkRDFConfig rawConfig
          config <- maybe (do putStrLn "Invalid configuration data"
                              exitWith $ ExitFailure 5)
                          return maybeConfig
          new <- mkNewRDFList config files
          old <- getRDFList config (statefile config)
          let (news',newState) = mkNewsAndState old new
          pending <- getRDFList config (pendingfile config)
          let news = mergeRDFLists pending news'
          newsPut <- putNews config news newState
          exitWith ExitSuccess

