-----------------------------------------------------------------------------
-- CVS $Id: RDFConfig.hs,v 1.6 2003/03/03 11:29:26 obraun Exp $
-- CVS $Unsane: projects/checkrdf/RDFConfig.hs,v 1.4 2005/05/29 19:27:39 lizard Exp $
-- |
--
-- Module      : RDFConfig
-- Copyright   : (c) Oliver Braun 2002-2005
-- License     : BSD
--
-- Maintainer  : obraun@informatik.unibw-muenchen.de
-- Stability   : provisional
-- Portability : portable
--
--
-----------------------------------------------------------------------------

module RDFConfig ( mkRDFConfig, RDFConfig(..) ) where

data RDFConfig = RDFConfig
     {outfile         :: FilePath
     ,statefile       :: FilePath
     ,pendingfile     :: FilePath
     ,pendingflagfile :: FilePath
     }

mkRDFConfig :: String -> Maybe RDFConfig
mkRDFConfig configstring =
  Just $ parseConfig $ concatMaybe $ map lexConfig $ lines configstring

lexConfig :: String -> Maybe (String,String)
lexConfig []      = Nothing
lexConfig s       =
  let (key,value') = span (/='=') $ dropWhile (==' ') s
  in  if not (null key) && not (null value')
      then Just (key,tail value')
      else Nothing

concatMaybe :: [Maybe a] -> [a]
concatMaybe = foldr (maybe id (:)) []

parseConfig :: [(String,String)] -> RDFConfig
parseConfig [] = error "No config to parse."
parseConfig xs = RDFConfig
  {outfile         = valueOfError "OUTFILE"         xs
  ,statefile       = valueOfError "STATEFILE"       xs
  ,pendingfile     = valueOfError "PENDINGFILE"     xs
  ,pendingflagfile = valueOfError "PENDINGFLAGFILE" xs
  }
 where valueOf name xs = let values = filter (\(k,v) -> k == name) xs
                         in  if null values
                             then []
                             else reverse $ dropWhile (==' ') $ reverse $ snd $ last values
       valueOfError name xs = let value = valueOf name xs
                              in  if null value
                                  then error $ "Missing value for: " ++ name
                                  else value

