#include <string.h>

#include "htmlparser.h"
#include "htmltokenizer.h"
#include "htmltag.h"
#include "colors.h"
#include "dw_page.h"

/* BODY tag functions */

__inline static void body_set_bgcolor(html_t *html, const char *color) 
{
	gint32 col;

	col = get_color_value(color);

	a_Dw_widget_set_bg_color(html->dw, col);
}

__inline static void body_set_bg_image(html_t *html, const char *image)
{
	return;
}

__inline static void body_set_link_color(html_t *html, const char *color)
{
	DwPage *page;
	gint32 col;

	col = get_color_value(color);

	page = (DwPage *)html->dw;
	page->link_color = col;
}

__inline static void body_set_vlink_color(html_t *html, const char *color)
{
	DwPage *page;
	gint32 col;

	col = get_color_value(color);

	page = (DwPage *)html->dw;
	page->visited_color = col;
}

__inline static void body_set_text_color(html_t *html, const char *color)
{
	DwStyle attr;
	gint32 col;

	col = get_color_value(color);

	attr = *(html->stack[html->stack_top].style);
	attr.color = a_Dw_style_color_new(col, html->cw->window->window);

	a_Dw_style_unref(html->stack[html->stack_top].style);
	html->stack[html->stack_top].style = a_Dw_style_new(&attr, html->cw->window->window);
}

__inline int html_body (html_t *html, char *tag, html_tag_args *args, tag_type type) 
{
	html_tag_args *cur;
	char *bgcolor, *background, *link, *vlink, *text;

	if(type == HTML_TAG_CLOSE) {
		html_pop_tag(html, BODY);
		return 0;
	}

	html_push_tag(html, BODY);
	
	/* Walk the list setting all arguments */

	bgcolor    = NULL;
	background = NULL;
	link       = NULL;
	vlink      = NULL;
	text       = NULL;

	cur = args;

	while(cur) {
			
		if(strcasecmp(cur->name, "BGCOLOR") == 0) 
			bgcolor = cur->value;

		 else if(strcasecmp(cur->name, "BACKGROUND") == 0)
			background = cur->value;
			
		else if(strcasecmp(cur->name, "LINK") == 0)
			link = cur->value;
			
		else if(strcasecmp(cur->name, "VLINK") == 0)
			vlink = cur->value;
				
		else if(strcasecmp(cur->name, "TEXT") == 0)
			text = cur->value;

		cur = cur->next;
	}

	/* Check switches. If anything was omitted set those
	 * values to default (eventually user preferences) */

	if(text)  
		body_set_text_color(html, text); 
	else
		body_set_text_color(html, "#000000");

	if(bgcolor)	body_set_bgcolor(html, bgcolor); 
	if(link)    body_set_link_color(html, link); 
	if(vlink)   body_set_vlink_color(html, vlink);

	return 0;
}
