/*
 * File: dw_hruler.c
 *
 * Copyright (C) 2000 Jorge Arellano Cid <jcid@inf.utfsm.cl>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "dw_hruler.h"

static void Dw_hruler_init(DwHruler * hruler);
static void Dw_hruler_class_init(DwHrulerClass * klass);

static void Dw_hruler_size_request(DwWidget * widget, DwRequisition * requisition);
static void Dw_hruler_draw(DwWidget * widget, DwRectangle * area, GdkEventExpose * event);

GtkType a_Dw_hruler_get_type(void)
{
	static GtkType type = 0;

	if (!type) {
		GtkTypeInfo info = {
			"DwHruler",
			sizeof(DwHruler),
			sizeof(DwHrulerClass),
			(GtkClassInitFunc) Dw_hruler_class_init,
			(GtkObjectInitFunc) Dw_hruler_init,
			(GtkArgSetFunc) NULL,
			(GtkArgGetFunc) NULL,
		};

		type = gtk_type_unique(DW_TYPE_WIDGET, &info);
	}

	return type;
}


DwWidget *a_Dw_hruler_new(gboolean shade)
{
	DwHruler *hruler;

	hruler = DW_HRULER(gtk_object_new(DW_TYPE_HRULER, NULL));
	hruler->shade = shade;

	return DW_WIDGET(hruler);
}


static void Dw_hruler_init(DwHruler * hruler)
{
	hruler->shade = TRUE;
}


static void Dw_hruler_class_init(DwHrulerClass * klass)
{
	GtkObjectClass *object_class;
	DwWidgetClass *widget_class;

	object_class = (GtkObjectClass *) klass;

	widget_class = (DwWidgetClass *) klass;
	widget_class->size_request = Dw_hruler_size_request;
	widget_class->draw = Dw_hruler_draw;
}


static void Dw_hruler_size_request(DwWidget * widget, DwRequisition * requisition)
{
	DwHruler *hruler;

	hruler = DW_HRULER(widget);

	requisition->width = 2;
	requisition->ascent = hruler->shade ? 2 : 1;
	requisition->descent = 0;
}


static void Dw_hruler_draw(DwWidget * widget, DwRectangle * area, GdkEventExpose * event)
{
	DwHruler *hruler;
	gint x, y;

	hruler = DW_HRULER(widget);
	x = Dw_widget_x_world_to_viewport(widget, widget->allocation.x);
	y = Dw_widget_y_world_to_viewport(widget, widget->allocation.y);

	if (hruler->shade) {
		gdk_draw_line(widget->window, widget->viewport->style->dark_gc[widget->viewport->state], x, y, x + widget->allocation.width, y);
		gdk_draw_line(widget->window, widget->viewport->style->light_gc[widget->viewport->state], x, y + (widget->allocation.ascent + widget->allocation.descent) - 1, x + widget->allocation.width, y + (widget->allocation.ascent + widget->allocation.descent) - 1);

		if (widget->allocation.ascent + widget->allocation.descent > 2) {
			gdk_draw_line(widget->window, widget->viewport->style->dark_gc[widget->viewport->state], x, y + 1, x, y + (widget->allocation.ascent + widget->allocation.descent) - 2);
			gdk_draw_line(widget->window, widget->viewport->style->light_gc[widget->viewport->state], x + widget->allocation.width, y + 1, x + widget->allocation.width, y + (widget->allocation.ascent + widget->allocation.descent) - 2);
		}
	} else {
		gdk_draw_rectangle(widget->window, widget->viewport->style->black_gc, TRUE, x, y, widget->allocation.width, widget->allocation.ascent + widget->allocation.descent);
	}
}
