#ifndef __DW_IMAGE_H__
#define __DW_IMAGE_H__

#include <stdio.h>
#include "dw_widget.h"
#include "dw_tooltip.h"		/* for DwTooltip */

#ifdef __cplusplus
extern "C" {
#endif				/* __cplusplus */

#define DW_TYPE_IMAGE           (a_Dw_image_get_type ())
#define DW_IMAGE(obj)           GTK_CHECK_CAST (obj,DW_TYPE_IMAGE, DwImage)
#define DW_IMAGE_CLASS(klass)   GTK_CHECK_CLASS_CAST (klass, DW_TYPE_IMAGE, \
                                   DwImageClass)
#define DW_IS_IMAGE(obj)        GTK_CHECK_TYPE (obj, DW_TYPE_IMAGE)

	typedef enum {
		DW_IMAGE_RGB
	} DwImageType;

	typedef struct _DwImage DwImage;
	typedef struct _DwImageClass DwImageClass;


	struct _DwImage {
		DwWidget widget;

		DwImageType type;
		guchar *buffer;
		gint width;
		gint height;

		/* non NULL if image is scaled */
		guchar *scaled_buffer;

		/* Alt "tooltip" for images */
		DwTooltip *alt_tooltip;
	};

	struct _DwImageClass {
		DwWidgetClass parent_class;
	};


/*
 * Function prototypes
 */
	GtkType a_Dw_image_get_type(void);
	DwWidget *a_Dw_image_new(DwImageType type, const gchar * alt);
	void a_Dw_image_size(DwImage * image, gint width, gint height);
	void a_Dw_image_draw_row(DwImage * image, gint Width, gint Height, gint x, gint y);
	void a_Dw_image_set_buffer(DwImage * image, guchar * ImageBuffer);

#ifdef __cplusplus
}
#endif				/* __cplusplus */
#endif				/* __DW_IMAGE_H__ */
