/* This module contains the dw_page widget, which is the "back end" to
   Web text widgets including html. */

#ifndef __DW_PAGE_H__
#define __DW_PAGE_H__

#undef USE_TYPE1

#include <gdk/gdk.h>
#include "dw_container.h"

#ifdef __cplusplus
extern "C" {
#endif				/* __cplusplus */

#define DW_TYPE_PAGE            (a_Dw_page_get_type ())
#define DW_PAGE(obj)            GTK_CHECK_CAST ((obj), DW_TYPE_PAGE, DwPage)
#define DW_PAGE_CLASS(klass)    GTK_CHECK_CLASS_CAST ((klass), DW_TYPE_PAGE, \
                                   DwPageClass)
#define DW_IS_PAGE(obj)         GTK_CHECK_TYPE ((obj), DW_TYPE_PAGE)
#define DW_IS_PAGE_CLASS(klass) GTK_CHECK_CLASS_TYPE ((klass), DW_TYPE_PAGE)

typedef struct _DwPage DwPage;
typedef struct _DwPageClass DwPageClass;

/* Internal data structures (maybe shouldn't be in public .h file? */
typedef struct _DwPageLink DwPageLink;
typedef struct _DwPageLine DwPageLine;
typedef struct _DwPageWord DwPageWord;
typedef struct _DwPageShape DwPageShape;

struct _DwPageLink {
	char *url;
	char *alt;
};

#define DW_PAGE_SHAPE_ERROR   0
#define DW_PAGE_SHAPE_DEFAULT 1
#define DW_PAGE_SHAPE_CIRCLE  2
#define DW_PAGE_SHAPE_RECT    3
#define DW_PAGE_SHAPE_POLY    4

struct _DwPageShape {
	guint map;
	gint type;
	gint link;

	union {
		GdkRegion *poly;
		struct {
			int x;
			int y;
			int r2;
		} circle;
		struct {
			int top;
			int bottom;
			int left;
			int right;
		} rect;
	} data;
};

/*
 * Link finding rules:
 * -------------------
 *   if (DwPageAttr->link)
 *     if (DwPageAttr HAS_MAP)
 *          // add server-side map informations to url
 *       else
 *          // regular link
 *   else if (DwPageAttr HAS_MAP)
 *        // client-side image map with (shapes)
 */

/* these defines are DwPageAttr->flags
 * ALIGN_LEFT == ALIGN_RIGTH ==0  -> CENTER
 * ALIGN_LEFT == ALIGN_RIGTH ==1  -> JUSTIFIED */

struct _DwPageLine {
	gint first_word;	/* position in the DwPageWord */
	gint last_word;

	gint y_top;
	gint x_size, y_ascent, y_descent, y_space;
	gboolean hard;	/* false = soft break, true = hard break */
	gboolean first;	/* true = first line in paragraph */
};

#define DW_PAGE_CONTENT_TEXT 0
#define DW_PAGE_CONTENT_WIDGET 1
#define DW_PAGE_CONTENT_ANCHOR 2

struct _DwPageWord {
	/* todo: perhaps add a x_left? */
	gint x_size, y_ascent, y_descent;
	gint x_space;	/* space after the word, only if it's not a break */

	/* This is a variant record (i.e. it could point to a widget 
	 * instead of just being text). */
	gint content_type;
	union {
		char *text;
		struct {
			DwWidget *widget;
			gfloat rel_width;	/* 0: do not resize,
						   otherwise: relative to DwPage's width */
			gfloat rel_height;	/* analogue */
		} widget;
		char *anchor;
	} content;

	DwStyle *style;
};


struct _DwPage {
	DwContainer container;

	GdkCursor *hand_cursor;

	/* These values are set by set_... */
	gint32 avail_width, avail_ascent, avail_descent;

	/* The avail_ values at which the page was rewrapped */
	gint32 wrapped_width, wrapped_ascent, wrapped_descent;

	/* The page width calculated by rewrapping / adding of words */
	gint32 real_width;

	/* the maximum width of the last line (assuming no word wrap) */
	gint last_line_max_width;

	DwPageLine *lines;
	gint num_lines;
	gint num_lines_max;	/* number allocated */

	DwPageWord *words;
	gint current_word;	/* The word that is being added to the lines */
	gint num_words;
	gint num_words_max;	/* number allocated */

	/* Page's maps
	 * Key: guint = g_str_hash(char *map)
	 * Value: num_shapes + 1 */
	DwPageShape *shapes;
	gint num_shapes;
	gint num_shapes_max;	/* number allocated */
	guint current_map;
	gint x_click, y_click;

	DwPageLink *links;
	gint num_links;
	gint num_links_max;

	/* We'll store current-page colors here */
	gint32 link_color;
	gint32 visited_color;
	gint32 bgnd_color;	/* todo: Is this necessary? */

	/* The link under a button press */
	gint link_pressed;

	/* The link under the button */
	gint hover_link;

	/* Dw** Parent; todo: Not needed in new Dw? */

};


struct _DwPageClass {
	DwContainerClass parent_class;

	void (*link_entered) (DwPage * page, const char *url);
	void (*link_pressed) (DwPage * page, const char *url, GdkEventButton * event);
	void (*link_released) (DwPage * page, const char *url, GdkEventButton * event);
	void (*link_clicked) (DwPage * page, const char *url, GdkEventButton * event);
};


DwWidget *a_Dw_page_new(void);
GtkType a_Dw_page_get_type(void);

void a_Dw_page_update_begin(DwPage * page);
void a_Dw_page_update_end(DwPage * page);
gint a_Dw_page_new_link(DwPage * page, const char *url, const char *alt);
void a_Dw_page_add_text(DwPage * page, char *text, DwStyle * style);
void a_Dw_page_add_widget(DwPage * page, DwWidget * widget, gfloat rel_width, gfloat rel_height, DwStyle * style);
void a_Dw_page_add_anchor(DwPage * page, char *name, DwStyle * style);
void a_Dw_page_add_space(DwPage * page, DwStyle * style);
void a_Dw_page_linebreak(DwPage * page);
void a_Dw_page_parbreak(DwPage * page, gint space);
void a_Dw_page_find_text(DwPage * page, char *search_string);

#ifdef __cplusplus
}
#endif				/* __cplusplus */
#endif				/* __DW_PAGE_H__ */
