#ifndef __DW_STYLE_H__
#define __DW_STYLE_H__

#include <gdk/gdktypes.h>

#define TEXT_SUB 0
#define TEXT_SUP 1

#define DW_STYLE_ALIGN_LEFT   1
#define DW_STYLE_ALIGN_RIGHT  2
#define DW_STYLE_HAS_MAP      4	/* will move */

typedef struct _DwStyle DwStyle;
typedef struct _DwStyleFont DwStyleFont;
typedef struct _DwStyleColor DwStyleColor;

struct _DwStyle {
	gint ref_count;

	DwStyleFont *font;
	gint link;		/* will perhaps move */
	gint uline;
	gint strike;
	gint SubSup;
	/*gint underline; */
	guint map;		/* will move */
	DwStyleColor *color;

	gint left_indent_first;
	gint left_indent_rest;
	gint right_indent;

	gint flags;		/* -EG :: was align */
};

struct _DwStyleFont {
	gint ref_count;

	char *name;
	gchar size;
	gchar bold;
	gchar italic;

#ifdef USE_TYPE1
	gint t1fontid;
#else
	GdkFont *font;
#endif
	gint space_width;
};

struct _DwStyleColor {
	gint ref_count;
	gint color_val;
	GdkColor color;
	GdkGC *gc;
};


void a_Dw_style_init(void);
void a_Dw_style_freeall(void);

void a_Dw_style_init_values(DwStyle * style_attrs, GdkWindow * window);

DwStyle *a_Dw_style_new(DwStyle * style_attrs, GdkWindow * window);
DwStyleFont *a_Dw_style_font_new(DwStyleFont * font_attrs);
DwStyleFont *a_Dw_style_font_new_from_list(DwStyleFont * font_attrs);
DwStyleColor *a_Dw_style_color_new(gint color_val, GdkWindow * window);

#define a_Dw_style_ref(style)   ((style)->ref_count++)
#define a_Dw_style_unref(style) if (--((style)->ref_count) == 0) \
                                   Dw_style_remove (style)


/* Don't use this function directly! */
void Dw_style_remove(DwStyle * style);

#endif				/* __DW_STYLE_H__ */
