#include <string.h>

#include "entity.h"

__inline static unsigned int entity_hash(const char *str, unsigned int len)
{
	static unsigned short asso_values[] = {
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 50,
		105, 70, 10, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 80, 20, 35, 15, 95,
		466, 65, 5, 160, 466, 35, 5, 10, 75, 63,
		75, 466, 20, 60, 70, 55, 466, 466, 10, 50,
		10, 466, 466, 466, 466, 466, 466, 120, 135, 210,
		190, 0, 5, 179, 160, 250, 0, 5, 25, 60,
		45, 244, 195, 5, 75, 168, 10, 10, 5, 0,
		0, 188, 5, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466, 466, 466, 466, 466,
		466, 466, 466, 466, 466, 466
	};
	return len + asso_values[(unsigned char) str[len - 1]] + asso_values[(unsigned char) str[0]];
}

__inline entity_t *lookup_entity(const char *str, unsigned int len)
{
	static entity_t wordlist[] = {
		{"eacute", 0351},
		{"egrave", 0350},
		{"zwj", 020015},
		{"zwnj", 020014},
		{"equiv", 021141},
		{"fnof", 0622},
		{"exist", 021003},
		{"trade", 020442},
		{"tilde", 01334},
		{"uacute", 0372},
		{"ugrave", 0371},
		{"quot", 34},
		{"frac14", 0274},
		{"frac34", 0276},
		{"Mu", 01634},
		{"tau", 01704},
		{"there4", 021064},
		{"le", 021144},
		{"euml", 0353},
		{"loz", 022712},
		{"frasl", 020104},
		{"forall", 021000},
		{"lt", 60},
		{"uml", 0250},
		{"uuml", 0374},
		{"lowast", 021027},
		{"ne", 021140},
		{"ntilde", 0361},
		{"epsilon", 01665},
		{"lceil", 021410},
		{"Yacute", 0335},
		{"nu", 01675},
		{"not", 0254},
		{"thorn", 0376},
		{"Uacute", 0332},
		{"Ugrave", 0331},
		{"upsilon", 01705},
		{"Ccedil", 0307},
		{"Oacute", 0323},
		{"Otilde", 0325},
		{"Ograve", 0322},
		{"mu", 01674},
		{"middot", 0267},
		{"thetasym", 01721},
		{"Yuml", 0570},
		{"Prime", 020063},
		{"Ntilde", 0321},
		{"Tau", 01644},
		{"Uuml", 0334},
		{"Aacute", 0301},
		{"Atilde", 0303},
		{"Agrave", 0300},
		{"Nu", 01635},
		{"lrm", 020016},
		{"uArr", 020721},
		{"uarr", 020621},
		{"Ouml", 0326},
		{"notin", 021011},
		{"Dagger", 020041},
		{"Eacute", 0311},
		{"Egrave", 0310},
		{"ETH", 0320},
		{"lArr", 020720},
		{"real", 020434},
		{"larr", 020620},
		{"rceil", 021411},
		{"lfloor", 021412},
		{"Upsilon", 01645},
		{"Auml", 0304},
		{"Scaron", 0540},
		{"Omicron", 01637},
		{"frac12", 0275},
		{"eta", 01667},
		{"Euml", 0313},
		{"acute", 0264},
		{"aacute", 0341},
		{"atilde", 0343},
		{"agrave", 0340},
		{"zeta", 01666},
		{"kappa", 01672},
		{"Lambda", 01633},
		{"Zeta", 01626},
		{"theta", 01670},
		{"rlm", 020017},
		{"macr", 0257},
		{"Delta", 01624},
		{"Beta", 01622},
		{"Epsilon", 01625},
		{"auml", 0344},
		{"THORN", 0336},
		{"lambda", 01673},
		{"rArr", 020722},
		{"rarr", 020622},
		{"rfloor", 021413},
		{"Kappa", 01632},
		{"eth", 0360},
		{"bull", 020042},
		{"Iacute", 0315},
		{"Igrave", 0314},
		{"nabla", 021007},
		{"sube", 021206},
		{"supe", 021207},
		{"upsih", 01722},
		{"sigmaf", 01702},
		{"ge", 021145},
		{"sdot", 021305},
		{"sect", 0247},
		{"times", 0327},
		{"nsub", 021204},
		{"Sigma", 01643},
		{"alefsym", 020465},
		{"Omega", 01651},
		{"Iuml", 0317},
		{"Gamma", 01623},
		{"gt", 62},
		{"empty", 021005},
		{"yacute", 0375},
		{"Theta", 01630},
		{"divide", 0367},
		{"emsp", 020003},
		{"ensp", 020002},
		{"prime", 020062},
		{"weierp", 020430},
		{"piv", 01726},
		{"Alpha", 01621},
		{"lang", 021451},
		{"part", 021002},
		{"ndash", 020023},
		{"thinsp", 020011},
		{"ecirc", 0352},
		{"brvbar", 0246},
		{"yuml", 0377},
		{"Eta", 01627},
		{"scaron", 0541},
		{"sup1", 0271},
		{"cent", 0242},
		{"ucirc", 0373},
		{"mdash", 020024},
		{"permil", 020060},
		{"Oslash", 0330},
		{"sim", 021074},
		{"sum", 021021},
		{"minus", 021022},
		{"yen", 0245},
		{"hArr", 020724},
		{"harr", 020624},
		{"cedil", 0270},
		{"ccedil", 0347},
		{"sup3", 0263},
		{"nbsp", 0240},
		{"alpha", 01661},
		{"plusmn", 0261},
		{"OElig", 0522},
		{"euro", 020254},
		{"oline", 020076},
		{"oacute", 0363},
		{"otilde", 0365},
		{"ograve", 0362},
		{"xi", 01676},
		{"ordf", 0252},
		{"image", 020421},
		{"iacute", 0355},
		{"igrave", 0354},
		{"reg", 0256},
		{"rang", 021452},
		{"beta", 01662},
		{"curren", 0244},
		{"Xi", 01636},
		{"int", 021053},
		{"AElig", 0306},
		{"Aring", 0305},
		{"iquest", 0277},
		{"Rho", 01641},
		{"dArr", 020723},
		{"darr", 020623},
		{"Ucirc", 0333},
		{"dagger", 020040},
		{"ouml", 0366},
		{"laquo", 0253},
		{"lsquo", 020030},
		{"ldquo", 020034},
		{"lsaquo", 020071},
		{"sup2", 0262},
		{"Ocirc", 0324},
		{"iuml", 0357},
		{"iexcl", 0241},
		{"Iota", 01631},
		{"Chi", 01647},
		{"crarr", 020665},
		{"radic", 021032},
		{"sigma", 01703},
		{"Acirc", 0302},
		{"omicron", 01677},
		{"ni", 021013},
		{"isin", 021010},
		{"infin", 021036},
		{"ang", 021040},
		{"aelig", 0346},
		{"gamma", 01663},
		{"aring", 0345},
		{"sub", 021202},
		{"ordm", 0272},
		{"micro", 0265},
		{"Ecirc", 0312},
		{"and", 021047},
		{"delta", 01664},
		{"amp", 38},
		{"para", 0266},
		{"asymp", 021110},
		{"or", 021050},
		{"rho", 01701},
		{"raquo", 0273},
		{"rsquo", 020031},
		{"rdquo", 020035},
		{"rsaquo", 020072},
		{"Pi", 01640},
		{"Phi", 01646},
		{"Psi", 01650},
		{"hearts", 023145},
		{"acirc", 0342},
		{"spades", 023140},
		{"szlig", 0337},
		{"shy", 0255},
		{"hellip", 020046},
		{"diams", 023146},
		{"sup", 021203},
		{"omega", 01711},
		{"deg", 0260},
		{"iota", 01671},
		{"Icirc", 0316},
		{"clubs", 023143},
		{"bdquo", 020036},
		{"prod", 021017},
		{"pound", 0243},
		{"cong", 021105},
		{"perp", 021245},
		{"prop", 021035},
		{"copy", 0251},
		{"cap", 021051},
		{"cup", 021052},
		{"oslash", 0370},
		{"oplus", 021225},
		{"sbquo", 020032},
		{"otimes", 021227},
		{"circ", 01306},
		{"oelig", 0523},
		{"pi", 01700},
		{"phi", 01706},
		{"psi", 01710},
		{"ocirc", 0364},
		{"chi", 01707},
		{"icirc", 0356}
	};

	static short lookup[] = {
		-1, -1, -1, -1, -1, -1, -264, -1,
		2, 3, 4, -252, -2, -1, 5, -283,
		-270, -243, -2, 11, -1, -277, 14, 15,
		-240, -2, 16, 17, -1, 18, -246, -3,
		-1, 19, -1, 20, 21, 22, 23, 24,
		-1, 25, -1, -1, -1, -1, -1, 26,
		-1, -1, -1, 27, 28, -1, -1, 29,
		30, 31, 32, -1, 33, -316, 36, -218,
		-2, -1, 37, -1, -1, -323, -214, -3,
		41, -1, -1, -1, 42, -1, 43, 44,
		45, 46, -1, 47, 48, -1, -346, 52,
		53, -343, -198, -2, 56, -203, -3, 57,
		58, -1, -1, -1, -1, -370, -1, 61,
		-365, 65, 66, 67, -1, 68, -1, 69,
		-190, -3, -1, 70, 71, -193, -2, -1,
		-1, -1, -1, 72, 73, 74, -380, -177,
		-3, 78, 79, 80, -1, -1, 81, 82,
		-1, -1, 83, 84, 85, -1, -1, -1,
		86, -1, -1, 87, -1, 88, 89, 90,
		-1, -1, -410, -1, 93, -161, -2, -1,
		94, -1, -1, 95, 96, -1, -420, -155,
		-2, -1, 99, -1, -426, -152, -2, 102,
		-1, -1, -1, 103, -1, 104, -450, 107,
		108, 109, -1, 110, 111, 112, 113, 114,
		-1, 115, 116, 117, 118, -147, -2, -459,
		121, 122, -1, 123, -1, 124, -133, -2,
		125, 126, 127, 128, -1, -1, -1, 129,
		130, 131, 132, 133, -1, -1, 134, -1,
		135, -480, 138, -116, -2, 139, -1, -487,
		-1, 142, -112, -2, 143, -1, -1, -593,
		146, 147, 148, -1, 149, 150, 151, 152,
		153, 154, -591, -1, 158, 159, -1, 160,
		-589, 163, 164, 165, -1, 166, 167, 168,
		-569, -1, 171, 172, -1, -538, 175, 176,
		-1, 177, -534, 181, -1, 182, 183, 184,
		185, -74, -3, -1, 186, -79, -2, -1,
		187, -1, -544, -64, -2, 190, -1, 191,
		192, 193, -1, 194, 195, -1, 196, -1,
		-564, -1, 200, -1, 201, 202, 203, -55,
		-3, 204, -1, 205, -83, -2, 206, 207,
		208, 209, 210, -1, -584, 214, -1, 215,
		-582, -36, -2, -41, -3, -1, 218, 219,
		-91, -2, -97, -3, -108, -2, 220, -1,
		-1, -1, -1, -1, -1, -1, -1, -1,
		221, -1, -1, -1, -1, -1, -1, 222,
		-1, 223, -1, 224, -1, -1, 225, -1,
		-1, 226, -1, -1, 227, -1, 228, 229,
		-1, -1, -1, -1, -1, -1, -1, 230,
		231, -1, -1, -1, -1, 232, 233, -1,
		-1, 234, -648, -17, -2, -1, -1, -1,
		-1, -1, 237, -1, -1, -1, -1, -1,
		-664, -1, 240, -14, -2, -1, -1, -1,
		-1, -672, 243, -11, -2, -1, -1, -1,
		244, -1, -1, -1, 245, -1, -1, -1,
		-1, -1, -1, -1, -1, -1, -1, -1,
		-1, -1, -1, -1, -1, -1, -1, 246,
		-702, -5, -2, -1, -1, -1, -1, -1,
		-1, -1, -1, 249, -1, -1, -1, 250,
		-1, 251
	};

	if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH) {

		register int key = entity_hash(str, len);

		if (key <= MAX_HASH_VALUE && key >= 0) {

			register int index = lookup[key];

			if (index >= 0) {

				register const char *s = wordlist[index].entity;

				if (*str == *s && !strcmp(str + 1, s + 1))
					return &wordlist[index];

			} else if (index < -TOTAL_KEYWORDS) {

				register int offset = -1 - TOTAL_KEYWORDS - index;
				register entity_t *wordptr = &wordlist[TOTAL_KEYWORDS + lookup[offset]];
				register entity_t *wordendptr = wordptr + -lookup[offset + 1];

				while (wordptr < wordendptr) {

					register const char *s = wordptr->entity;

					if (*str == *s && !strcmp(str + 1, s + 1))
						return wordptr;

					wordptr++;
				}
			}
		}
	}
	return 0;
}

int get_entity(const char *entity)
{
	entity_t *ent;

	ent = lookup_entity(entity, strlen(entity));
	if(ent)
		return ent->isocode;

	return -1;
}
