/*******************************************************************************
 *
 * error.c - Functions for reporting errors to the user.
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include <gtk/gtk.h>

#include "gui.h"
#include "icons.h"
#include "error.h"

GtkWidget *dialog;

void create_error_dialog(char *msg);

/*
 * error() - display an error message to the user
 */

void error(char *msg, ...)
{
	va_list args;
	char string[512];

	va_start(args, msg);
	vsnprintf(string, 511, msg, args);
	va_end(args);

	create_error_dialog(string);
}

/*
 * close_dialog() - closes the dialog when the user hits ok
 */

static void close_dialog()
{
	gtk_widget_destroy(dialog);
}

/*
 * create_error_dialog() - creates the error dialog
 */

void create_error_dialog(char *string)
{
	GdkPixmap *icon;
	GtkWidget *iconw;
	GdkBitmap *mask;

	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *hbox;

	/* Create the dialog */

	dialog = gtk_dialog_new();
	gtk_widget_set_usize(GTK_WIDGET(GTK_DIALOG(dialog)), 390, 100);

	/* Create a horizontal box for the icon and message */

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* Show the dialog before pixmaps are created */

	gtk_widget_show(dialog);

	/* Create the icon */

	icon = gdk_pixmap_create_from_xpm_d(dialog->window, &mask,
					&dialog->style->white, stop_xpm);

	iconw = gtk_pixmap_new(icon, mask);
	gtk_box_pack_start(GTK_BOX(hbox), iconw, TRUE, FALSE, 0);
	gtk_widget_show(iconw);

	/* Create the message lable */

	label = gtk_label_new(string);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, FALSE, 0);
	gtk_widget_show(label);

	/* Create the okay button */

	button = gtk_button_new_with_label("OK");
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	gtk_signal_connect(GTK_OBJECT(button), "clicked", 
					GTK_SIGNAL_FUNC(close_dialog), 0);

}
