/*******************************************************************************
 *
 * font.c 
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "font.h"
#include "htmltokenizer.h"
#include "htmltag.h"
#include "colors.h"
#include "debug.h"

char *font_find_face(const char *faces);

/*
 * html_set_font() - set the font. 
 *
 * Initial code taken from dillo project */

void html_set_font(html_t *html, char *name, int size, int bold)
{
	DwStyle style_attrs;
	DwStyleFont font;

	style_attrs = *(html->stack[html->stack_top].style);
	font = *(style_attrs.font);

   	if(name)
    	font.name = name;
	
   	if(size)
      	font.size = size;
	
   	if(bold >= 0) {
    	font.bold   = (bold & 1) ? TRUE : FALSE;
      	font.italic = (bold & 2) ? TRUE : FALSE;
   	}
	
	style_attrs.font = a_Dw_style_font_new(&font);

	a_Dw_style_unref(html->stack[html->stack_top].style);
   	html->stack[html->stack_top].style = a_Dw_style_new(&style_attrs, html->cw->window->window);
}

/*
 * html_set_font_color() - sets the font and changes the color of the font.
 */

void html_set_font_color(html_t *html, char *name, int size, int bold, gint32 color)
{
	DwStyle style_attrs;
	DwStyleFont font;

	style_attrs = *(html->stack[html->stack_top].style);
	font = *(style_attrs.font);

   	if(name)
    	font.name = name;
	
   	if(size)
      	font.size = size;
	
   	if(bold >= 0) {
    	font.bold   = (bold & 1) ? TRUE : FALSE;
      	font.italic = (bold & 2) ? TRUE : FALSE;
   	}
	
	if(color >= 0) 
		style_attrs.color = a_Dw_style_color_new(color, html->cw->window->window);

	style_attrs.font = a_Dw_style_font_new(&font);

	a_Dw_style_unref(html->stack[html->stack_top].style);
   	html->stack[html->stack_top].style = a_Dw_style_new(&style_attrs, html->cw->window->window);
}

/*
 * font_compute_size() - compute the fontsize based on the 'size' 
 * font tag attribute
 */

__inline static int font_compute_size(html_t *html, const char *size)
{
	DwStyle attr;
	DwStyleFont font;

	static int sizes[] = { 8, 10, 12, 14, 16, 18, 24 };
	int level; 
	int fontsize = 0, plus = 0;	
	
	if(!html || !size)
		return 0;

	attr = *(html->stack[html->stack_top].style);
	font = *(attr.font);

	if(*size == '+') {

		level = size[1] - '0';
		plus = 1;

	} else
		level = size[0] - '0';

	if(plus) {

		int index;

		if(html->basefont > 0) 
			index = html->basefont + level - 1;
		else 
			index = (font.size % 7) + level-1;

		if(index > 6) index = 6;
		if(index < 0) index = 0;

		fontsize = sizes[index];

	} else 
		fontsize = sizes[level-1];

	return fontsize;
}

/* HTML tag implementations. Prototypes for these functions must be
 * in html.h */

/*
 * html_font() - <FONT> tag
 */

__inline int html_font (html_t *html, char *tag, html_tag_args *args, tag_type type) 
{
	DwStyle attr;
	DwStyleFont font;
	html_tag_args *cur;
	gint32 col;
	int fontsize;
	char *size, *color, *face;

	if(type == HTML_TAG_CLOSE) {
		html_pop_tag(html, FONT);
		return 0;
	}

	/* Extract all useful arguments */

	size = color = face = NULL;

	cur = args;

	while(cur) {
	
		if(strcasecmp(cur->name, "size") == 0)
			size = cur->value;

		else if(strcasecmp(cur->name, "color") == 0)
			color = cur->value;

		else if(strcasecmp(cur->name, "face") == 0)
			face = cur->value;

		cur = cur->next;
	}

	html_push_tag(html, FONT);

	attr = *(html->stack[html->stack_top].style);
	font = *(attr.font);

	/* Size */

	fontsize = 0;

	if(size)
		fontsize = font_compute_size(html, size);

	/* color */

	col = -1;

	if(color)
		col = get_color_value(color);
	
	/* Font face */

	if(face) {
		font.name = face;
		attr.font = a_Dw_style_font_new_from_list(&font);
	}

	html_set_font_color(html, font.name, fontsize, 0, col);

	//html_set_font(html, font.name, fontsize, 0);

	return 0;
}

/*
 * html_basefont() - <BASEFONT> tag
 */

__inline int html_basefont (html_t *html, char *tag, html_tag_args *args, tag_type type) 
{
	html_tag_args *cur;
	char *size = NULL;

	if(type == HTML_TAG_CLOSE)
		return -1;
	
	cur = args;

	while(cur) {

		if(strcasecmp(cur->name, "size") == 0)
			size = cur->value;

		cur = cur->next;
	}
	
	if(size) {
		debug_print("Setting basefont to %d", size[0] - '0');
		html->basefont = size[0] - '0';
	}

	return 0;
}
