#ifndef __FORM_H__
#define __FORM_H__

#include <gtk/gtk.h>

//#include "form_control.h"

typedef enum { GET, POST } FormMethod;

/* Don't use typedef enum here since gcc will generate
 * lot's of warnings if you don't use any but not _all_ 
 * of these in a switch */

enum {
	INPUT_TEXT, INPUT_PASSWORD, INPUT_CHECKBOX, INPUT_RADIO, 
	INPUT_SUBMIT, INPUT_RESET, INPUT_FILE, INPUT_HIDDEN,
	INPUT_IMAGE, INPUT_BUTTON, NUM_INPUTS
};
typedef int InputType;

typedef struct _ControlList ControlList;
typedef struct _HtmlForm HtmlForm;
typedef struct _FormControl FormControl;
typedef struct _FormList FormList;
typedef struct _FileControl FileControl;

/* 
 * Structure used to lookup input types
 */

typedef struct {
	char *type;
	InputType id;
} InputTypeStruct;

/*
 * Linked list of controls in a form
 */

struct _ControlList {
	FormControl *control;
	struct _ControlList *next;
};

/*
 * Structure to describe a form
 */

struct _HtmlForm {
	char *action;
	char *enctype;
	char *charset;
	char *name;	
	char *accept;
	ControlList *control_list;
	FormMethod method;
};

/*
 * Structure to describe a Form Control 
 */

struct _FormControl {

	char *name;
	char *value;
	char *src;

	int maxlength;
	int size;

	gboolean checked;

	InputType type;

	GtkWidget *widget;

	FileControl *file;

	HtmlForm *form;
};

/* 
 * Structure to describe file input type 
 */

struct _FileControl {
	GtkWidget *select;
	GtkWidget *entry;
	GtkWidget *button;
};

/*
 * Linked list of forms in an html document
 */

struct _FormList {
	HtmlForm *form;
	struct _FormList *next;
};

void form_list_free(FormList *list);

#endif
