/*******************************************************************************
 *
 * gui.h
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley, Felipe Bergo 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#ifndef __GUI_H__
#define __GUI_H__

#include <gtk/gtk.h>

#include "history.h"
#include "uri.h"

typedef struct {
	char  text[256];
	int   seq;
	int   pop; /* if pop==seq message should be popped */
} GuiMessage;

typedef struct {
	uri_t *uri;
	char  *source;
	int   done;
	GuiMessage status;
} InterThread;

typedef struct {

	GtkWidget *window;
	
	GtkWidget *docwin;
	GtkWidget *toolbar;
	GtkWidget *menubar;
	GtkWidget *status_bar;

	GtkWidget *progress;
	
	GtkWidget *location_box;
	GtkWidget *location_label;
	GtkWidget *spinner;
	
	GtkWidget *label;
	
	//history_t *history;

	/* stop requested */
	int req_stop; 

	int spinner_timer;
	int progress_timer;

} CheetahWindow;

CheetahWindow *cheetah_window_new();
void close_all_windows(void);

int cheetah_load_uri(CheetahWindow *cw, const char *uri_string);

void set_window_title(CheetahWindow *cw, const char *title);
void cheetah_window_set_cursor(CheetahWindow *cw, GdkCursorType type);

void load_cheetah_page(GtkWidget *w, CheetahWindow *cw);

void cheetah_load_spinner_xpms(GtkWidget *window);
gboolean cheetah_spinner(gpointer data);

void cheetah_stop_cb(GtkWidget *w, gpointer data);

#endif
