#ifndef __HTML_H__
#define __HTML_H__

#include "htmlparser.h"
#include "htmltag.h"

typedef enum { 
	HTML_TAG_OPEN, HTML_TAG_CLOSE
} tag_type;

void html_add_widget(html_t *html, DwWidget *widget, char *width, char *height, DwStyle *style);

__inline int html_head	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_q	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_title	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_body	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_br	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_para	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_nobr	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_header	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_tt	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_tfoot	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_label	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_basefont	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_link	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_big	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_tbody	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_tr	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_font	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_bold	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_fieldset	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_frameset	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_form	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_script	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_select	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_var	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_table	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_small	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_em	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_strong	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_map	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_param	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_ul	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_sub	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_menu	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_td	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_dt	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_base	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_thead	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_dl	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_blockquote	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_legend	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_div	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_strike(html_t *,char *, html_tag_args *, tag_type);
__inline int html_col	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_frame	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_kbd	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_style	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_object	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_ol	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_sup	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_samp	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_applet	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_pre	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_textarea	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_meta	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_acronym	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_dir	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_bdo	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_underline	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_noscript	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_center	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_input	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_li	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_code	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_cite	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_th	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_img	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_abbr	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_button	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_dd	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_colgroup	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_html	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_address	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_isindex	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_optgroup	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_span	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_noframes	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_ins	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_hr	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_iframe	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_dfn	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_a	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_area	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_caption	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_option	(html_t *,char *, html_tag_args *, tag_type);
__inline int html_italic	(html_t *,char *, html_tag_args *, tag_type);

#endif
