/*******************************************************************************
 *
 * htmlparser.h - HTML parsing engine
 *
 * Original code taken from libhtmlparse by Mooneer Salem
 * (mooneer@translator.cx) http://msalem.translator.cx/libhtmlparse.html
 * 
 * Completely butchered by Garett Spencley for the Cheetah Web Browser.
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#ifndef __HTML_PARSER_H__
#define __HTML_PARSER_H__

#include "gui.h"
#include "dw_widget.h"
#include "dw_page.h"
#include "uri.h"
#include "form.h"

typedef struct {
	DwStyle *style;
	unsigned int tag;
} tag_info_t;

typedef struct {

	DwWidget *dw;
	CheetahWindow *cw;

	char *baseuri;

	int basefont;

	tag_info_t *stack;

	FormList *formlist;

	int stack_top;
	int stack_max;

	gboolean script;
	gboolean css;
	gboolean preformatted;

	GuiMessage *message;

} html_t;

__inline void html_push_tag (html_t *, unsigned int);
__inline void html_pop_tag  (html_t *, unsigned int);
__inline int html_seek_tag  (html_t *, unsigned int);

__inline const char *parse_text         (html_t *html, const char *);
__inline const char *parse_comment      (html_t *html, const char *);
__inline const char *parse_closing_tag  (html_t *html, const char *);
__inline const char *parse_opening_tag  (html_t *html, const char *);
__inline const char *parse_dtd          (html_t *html, const char *);

__inline int parse_for_entities (html_t *html, const char *);

void html_parse_document(html_t *html, const char *source);
void html_render_document(CheetahWindow *cw, uri_t *uri, const char *source);

#endif

