/*******************************************************************************
 *
 * htmltag.c - HTML parsing engine. 
 *                   
 * These routines parse the the individual html tags and store the 
 * attributes into a linked list.
 * 
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#ifndef __HTML_TAG_H__
#define __HTML_TAG_H__

typedef struct html_tag_arg_t {
	char *name;
	char *value;	
	struct html_tag_arg_t *next;
} html_tag_args;

html_tag_args *create_tag_args(const char *string);
html_tag_args *allocate_tag_args();
void free_html_tag_args(html_tag_args *args);
html_tag_args *duplicate_tag_args(html_tag_args *args);

#endif
