/*******************************************************************************
 *
 * htmltokenizer.h - HTML parsing engine
 *
 * Hash functions for identifying html tags.
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *****************************************************************************/

#ifndef __HTML_TOKENIZER_H__
#define __HTML_TOKENIZER_H__

#include "htmltag.h"
#include "html.h"
#include "htmlparser.h"

enum {
	HTML_TAG_UNKOWN, HTML, HEAD, TITLE, BODY, CENTER, BOLD, UNDERLINE, 
	ITALIC,	PRE, SCRIPT, H1, H2, H3, H4, H5, H6, HEADER, FONT, TABLE,
	TR, TD, PARA, BR, NOSCRIPT, CODE, FORM, INPUT, IMG, A, CITE, UL, OL,
	LI, ABBR, ACRONYM, ADDRESS, APPLET, AREA, BASE, BASEFONT, BDO, BIG, 
	BLOCKQUOTE, BUTTON, CAPTION, COL, COLGROUP, DD, STRIKE, DFN, DIRECTORY, 
	DIV, DL, DT, EM, FIELDSET, FRAME, FRAMESET, HR, IFRAME, INS, ISINDEX, 
	KBD, LABEL, LEGEND, LINK, MAP, MENU, META, NOFRAMES, OBJECT, OPTGROUP, 
	OPTION, PARAM, QUOTE, SAMP, SELECT, SMALL, SPAN, STRONG, STYLE, SUB, 
	SUP, TBODY, TEXTAREA, TFOOT, TH, THEAD, TT, VAR, NOBR,
};
typedef unsigned int HTML_TAG_ID;

typedef struct {
	char *tag;
	HTML_TAG_ID id;
	int (*tag_func)(html_t *, char *, html_tag_args *, tag_type);
} html_token;

html_token *get_tag(char *);

#endif
