/*******************************************************************************
 *
 * http.h
 *
 * Provides the means for communicating with remote servers via http
 *
 * Version info etc.
 * 
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#ifndef __HTTP_H__
#define __HTTP_H__

#include <stdlib.h>

#include "gui.h"

enum {
	HTTP_ERROR_UNKOWN, HTTP_ALREADY_CONNECTED,
	HTTP_RESOLV, HTTP_CONNECT, HTTP_NOMEM, HTTP_CONTENT_LENGTH,
	HTTP_NOT_CONNECTED, HTTP_FILE_DESC
};

extern int http_errno;

typedef struct {
	char *data;
	char *content_type;
	size_t bytes;
} HttpFile;

int http_connect(char *host, unsigned short port, GuiMessage *msg);
int http_connection_open(void);
int http_close(void);
void http_file_free(HttpFile *);
void http_perror(char *error, char *dest);
HttpFile *http_get(char *path, GuiMessage *msg);

#endif
