/*******************************************************************************
 *
 * image.h
 *
 * Original code from dillo http://dillo.sourceforge.net
 * 
 * Hacked by Garett Spencley for the Cheetah Web Browser.
 *
 * Copyright (C) 1997 Raph Levien <raph@acm.org>
 * Copyright (C) 1999 James McCollough <jamesm@gtwn.net>
 * Copyright (C) 2001 Garett Spencley <gspen@home.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "image.h"

static size_t linebuf_size = 0;
static guchar *linebuf = NULL;

/*
 * Decode 'buf' (an image line) into RGB format.
 */

static guchar *Image_line(ImageData * Image, const guchar * buf, const guchar * cmap, gint y)
{
	guint x;

	switch (Image->in_type) {

	case IMG_TYPE_INDEXED:

		for (x = 0; x < Image->width; x++)
			memcpy(linebuf + x * 3, cmap + buf[x] * 3, 3);

		break;

	case IMG_TYPE_GRAY:

		for (x = 0; x < Image->width; x++)
			memset(linebuf + x * 3, buf[x], 3);

		break;

	case IMG_TYPE_RGB:

		/* avoid a memcpy here!  --Jcid */
		return (guchar *) buf;

	case IMG_TYPE_NOTSET:
		g_warning("ERROR: Image type not set...\n");
		break;
	}

	return linebuf;
}

/*
 * Set initial parameters of the image
 */

void Image_set_parms(ImageData * Image, guchar *buffer, guint width, guint height, ImageType type)
{
	if (!Image->dw->buffer)
		a_Dw_image_set_buffer(Image->dw, buffer); 

	if (!Image->BitVec)
		Image->BitVec = a_Bitvec_new(height);

	Image->in_type = type;
	Image->width = width;
	Image->height = height;

	if (3 * width > linebuf_size) {
		linebuf_size = 3 * width;
		linebuf = g_realloc(linebuf, linebuf_size);
	}
	Image->State = IMG_SetParms;

	a_Dw_image_size(Image->dw, width, height);
}

/*
 * Reference the dicache entry color map
 */

void Image_set_cmap(ImageData * Image, const guchar * cmap)
{
	Image->cmap = cmap;
	Image->State = IMG_SetCmap;
}

/*
 * Implement the write method
 */

void Image_write(ImageData * Image, const guchar * buf, guint y, gint decode)
{
	guchar *newbuf;

	g_return_if_fail(y < Image->height);

	if (decode) {
		/* Decode 'buf' and copy it into the DicEntry buffer */
		newbuf = Image_line(Image, buf, Image->cmap, y);
		memcpy(Image->dw->buffer + y * Image->width * 3, newbuf, Image->width * 3);
	}

	a_Bitvec_set_bit(Image->BitVec, y);
	Image->State = IMG_Write;

	/* Update the row in DwImage */
	a_Dw_image_draw_row(Image->dw, Image->width, Image->height, 0, y);
}

void Image_close(ImageData * Image)
{
	a_Bitvec_free(Image->BitVec);
	g_free(Image);
}

/*
 * Create and initialize a new image structure.
 */

ImageData *Image_new(gint width, gint height, const char *alt, gint32 bg_color)
{
	ImageData *Image;

	Image = g_new(ImageData, 1);
	Image->dw = (DwImage *) a_Dw_image_new(DW_IMAGE_RGB, alt);
	Image->width = 0;
	Image->height = 0;
	Image->cmap = NULL;
	Image->in_type = IMG_TYPE_NOTSET;
	Image->bg_color = bg_color;
	Image->ProcessedBytes = 0;
	Image->BitVec = NULL;
	Image->State = IMG_Empty;

	return Image;
}
