/*******************************************************************************
 *
 * image.h
 *
 * Original code from dillo http://dillo.sourceforge.net
 * 
 * Hacked by Garett Spencley for the Cheetah Web Browser.
 *
 * Copyright (C) 1997 Raph Levien <raph@acm.org>
 * Copyright (C) 1999 James McCollough <jamesm@gtwn.net>
 * Copyright (C) 2001 Garett Spencley <gspen@home.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#ifndef __IMAGE_H__
#define __IMAGE_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "dw_image.h"
#include "bitvec.h"

typedef enum {
	IMG_TYPE_INDEXED,
	IMG_TYPE_RGB,
	IMG_TYPE_GRAY,
	IMG_TYPE_NOTSET
} ImageType;

typedef enum {
	IMG_Empty,		/* Just created the entry */
	IMG_SetParms,		/* Parameters set */
	IMG_SetCmap,		/* Color map set */
	IMG_Write,		/* Feeding the entry */
	IMG_Close,		/* Whole image got! */
	IMG_Abort		/* Image transfer aborted */
} ImageState;

typedef struct {
	DwImage *dw;

	/* Parameters as told by image data */
	guint width;
	guint height;

	const guchar *cmap;	/* Color map (only for indexed) */
	ImageType in_type;	/* Image Type */
	gint32 bg_color;	/* Background color */

	gint ProcessedBytes;	/* Amount of bytes already decoded */
	bitvec_t *BitVec;	/* Bit vector for decoded rows */
	ImageState State;
} ImageData;


ImageData *Image_new(gint width, gint height, const char *alt, gint32 bg_color);

void Image_set_parms(ImageData * Image, guchar *buffer, guint width, guint height, ImageType type);

void Image_set_cmap(ImageData * Image, const guchar * cmap);
void Image_write(ImageData * Image, const guchar * buf, guint y, gint decode);
void Image_close(ImageData * Image);

#endif
