/*******************************************************************************
 *
 * img_gif.h 
 *                   
 * Original code from dillo http://dillo.sourceforge.net
 *
 * Hacked by Garett Spencley for Cheetah Web Browser
 *
 *  Adapted by Raph Levien from giftopnm.c as found in the
 *  netpbm-1mar1994 release. The copyright notice for giftopnm.c
 *  follows:
 */

/* +-------------------------------------------------------------------+ */
/* | Copyright 1990, 1991, 1993, David Koblas.  (koblas@netcom.com)    | */
/* |   Permission to use, copy, modify, and distribute this software   | */
/* |   and its documentation for any purpose and without fee is hereby | */
/* |   granted, provided that the above copyright notice appear in all | */
/* |   copies and that both that copyright notice and this permission  | */
/* |   notice appear in supporting documentation.  This software is    | */
/* |   provided "as is" without express or implied warranty.           | */
/* +-------------------------------------------------------------------+ */

/*
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#ifndef __IMG_GIF_H__
#define __IMG_GIF_H__

#include "image.h"

#define INTERLACE      0x40
#define LOCALCOLORMAP  0x80

#define LM_to_uint(a,b)   ((((guchar)b)<<8)|((guchar)a))

#define        MAXCOLORMAPSIZE         256
#define        MAX_LWZ_BITS            12

typedef struct _DilloGif {
	ImageData *Image;
	
   gint state;
   size_t Start_Ofs;
   guint Flags;

   guchar input_code_size;
   guchar *linebuf;
   gint pass;

   guint y;

   /* state for lwz_read_byte */
   gint code_size;

   /* The original GifScreen from giftopnm */
   guint Width;
   guint Height;
   size_t ColorMap_ofs;
   guint ColorResolution;
   guint NumColors;
   gint Background;
   guint spill_line_index;

   /* Gif89 extensions */
   gint transparent;

   /* state for the new push-oriented decoder */
   gint packet_size;       /* The amount of the data block left to process */
   guint window;
   gint bits_in_window;
   guint last_code;        /* Last "compressed" code in the look up table */
   guint line_index;
   guchar **spill_lines;
   gint num_spill_lines_max;
   gint length[(1 << MAX_LWZ_BITS) + 1];
   gint code_and_byte[(1 << MAX_LWZ_BITS) + 1];

} GifImage;

GifImage *Gif_new(ImageData *Image);
void Gif_write(GifImage *gif, void *Buf, gint BufSize);
void Gif_close(GifImage *gif);

#endif
