/*******************************************************************************
 *
 * img_jpeg.h 
 *                   
 * Original code from dillo http://dillo.sourceforge.net
 *
 * Hacked by Garett Spencley for Cheetah Web Browser
 *
 * Copyright (C) 1997 Raph Levien <raph@acm.org>
 * Copyright (C) 1999 James McCollough <jamesm@gtwn.net>
 * Copyright (C) 2000 Jorge Arellano Cid <jcid@users.sourceforge.net>
 * Copyright (C) 2001 Garett Spencley <gspen@home.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#ifndef __JPEG_H__
#define __JPEG_H__

#include <setjmp.h>
#include <jpeglib.h>

#include "image.h"

typedef enum {
	JPEG_INIT,
	JPEG_STARTING,
	JPEG_READING,
	JPEG_DONE,
	JPEG_ERROR
} JpegState;

/* An implementation of a suspending source manager */

typedef struct {
	struct jpeg_source_mgr pub;	/* public fields */
	struct JpegImage *jpeg;	/* a pointer back to the jpeg object */
} my_source_mgr;

struct my_error_mgr {
	struct jpeg_error_mgr pub;	/* "public" fields */
	jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr *my_error_ptr;

typedef struct JpegImage {
	ImageData *Image;

	my_source_mgr Src;

	JpegState state;
	size_t Start_Ofs, Skip, NewStart;
	char *Data;

	guint y;

	struct jpeg_decompress_struct cinfo;
	struct my_error_mgr jerr;

} JpegImage;

JpegImage *Jpeg_new(ImageData *Image);

void Jpeg_write(JpegImage *jpeg, void *Buf, guint BufSize);
void Jpeg_close(JpegImage *jpeg);

#endif
