/*******************************************************************************
 *
 * main.c - duh
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#include <stdio.h>
#include <glib.h>

#include "cheetah.h"
#include "gui.h"
#include "dw_style.h"
#include "debug.h"

void cheetah_quit()
{
	close_all_windows();
	gtk_main_quit();
}

int main(int argc, char **argv)
{
	CheetahWindow *window;

	debug_print("The Cheetah is getting out of bed.");

	g_thread_init(NULL);
	gtk_init(&argc, &argv);

	a_Dw_style_init();

	window = cheetah_window_new();
	if(!window) {
		fprintf(stderr, "Unable to create window\n");
		return -1;
	}

	set_window_title(window, CHEETAH_WINDOW_TITLE);
	
	debug_print("Good morning. How are you today?");

	gtk_main();

	debug_print("Bubbye now.");

	a_Dw_style_freeall();

	return 0;
}
