/*******************************************************************************
 *
 * menu.c  
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Steingrim Dovland
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#include <gtk/gtk.h>
#include "menu.h"
#include "http.h"
#include "debug.h"
#include "gui.h"

__inline void create_file_menu();
__inline void create_edit_menu();
__inline void create_settings_menu();
__inline void create_bookmarks_menu();
__inline void create_help_menu();

void file_menu_response(gchar * string);
void edit_menu_response(gchar * string);
void settings_menu_response(gchar * string);
void bookmarks_menu_response(gchar * string);
void help_menu_response(gchar * string);

static GtkWidget *menu_bar;
static GtkWidget *separator;
static GtkWidget *menu_items;

/* the bookmarks-menu is needed in elsewhere and is global */

GtkWidget *bookmarks_menu;
GtkWidget *bookmarks_item;
GtkWidget *bookmarks_menu_item;

/*
 * GtkWidget *create_menubar()
 * creates the menu the hard way
 *
 */

GtkWidget *create_menubar(CheetahWindow * cw)
{
	menu_bar = gtk_menu_bar_new();

	create_file_menu();
	create_edit_menu();
	create_settings_menu();
	create_bookmarks_menu();
	create_help_menu();

	return menu_bar;
}

/*
 * items on the file menu, when adding new items, add them here,
 * increase the guint, and add the callback below.
 *
 */

static guint number_of_file_menu_items = 10;

static gchar *file_menu_items[] = {
	"New window",
	"Open location",
	"Open file",
	"-",
	"Close window",
	"Save as",
	"-",
	"Print",
	"-",
	"Quit",
};

/*
 * callbacks for the file menu 
 *
 */

void file_menu_response(gchar * string)
{
	/* what item was activated ? */
	if (g_strcasecmp(string, "New window") == 0)
		cheetah_window_new();
	else if (g_strcasecmp(string, "Open location") == 0);
	else if (g_strcasecmp(string, "Open file") == 0);
	else if (g_strcasecmp(string, "Close window") == 0);
	else if (g_strcasecmp(string, "Save as") == 0);
	else if (g_strcasecmp(string, "Print") == 0);
	else if (g_strcasecmp(string, "Quit") == 0)
		cheetah_quit();
	else
		g_print("What tha hell? You asked for File->%s ! ", string);
}

/*
 * items on the edit menu, when adding new items, add them here,
 * increase the guint, and add the callback below.
 */

static guint number_of_edit_menu_items = 10;
static gchar *edit_menu_items[] = {
	"Undo",
	"Redo",
	"-",
	"Cut",
	"Copy",
	"Paste",
	"-",
	"Select all",
	"-",
	"Find on this page",
};

/*
 * callbacks for the edit menu 
 *
 */

void edit_menu_response(gchar * string)
{

	if (g_strcasecmp(string, "Undo") == 0);
	else if (g_strcasecmp(string, "Redo") == 0);
	else if (g_strcasecmp(string, "Cut") == 0);
	else if (g_strcasecmp(string, "Copy") == 0);
	else if (g_strcasecmp(string, "Paste") == 0);
	else if (g_strcasecmp(string, "Select all") == 0);
	else if (g_strcasecmp(string, "Find on this page") == 0);
	else
		g_print("What? You asked for Edit->%s ! ", string);
}


static guint number_of_settings_menu_items = 1;
static gchar *settings_menu_items[] = {
	"Preferences",
};

/*
 * callbacks for the settings menu 
 *
 */

void settings_menu_response(gchar * string)
{
	if (g_strcasecmp(string, "Preferences") == 0);
	else
		g_print("What? You asked for Settings->%s ! ", string);
}

/*
 * bookmarks, to be done  
 */
guint number_of_bookmarks_menu_items = 2;

/*
 * callbacks for the bookmarks menu 
 *
 */
void bookmarks_menu_response(gchar * string)
{
	if (g_strcasecmp(string, "Add bookmark") == 0);
	else if (g_strcasecmp(string, "Edit bookmarks") == 0);
	else {
		/* open bookmark */
	}
}

/*
 * callbacks for the help menu 
 *
 */

void help_menu_response(gchar * string)
{
	if (g_strcasecmp(string, "About") == 0);
}

/*
 * creates the file menu in GtkWidget *menu_bar
 *
 */

__inline void create_file_menu()
{
	GtkWidget *file_menu;
	GtkWidget *file_item;
	GtkWidget *file_menu_item;
	int i;

	/* create menu the hard way.. */
	file_menu = gtk_menu_new();

	for (i = 0; i < number_of_file_menu_items; i++) {
		if (g_strcasecmp(file_menu_items[i], "-") != 0) {
			/* create ordinary menu item */
			file_menu_item = gtk_menu_item_new_with_label(file_menu_items[i]);
			gtk_menu_append(GTK_MENU(file_menu), file_menu_item);
			gtk_widget_show(file_menu_item);
			gtk_signal_connect_object(GTK_OBJECT(file_menu_item), "activate", GTK_SIGNAL_FUNC(file_menu_response), (gpointer) file_menu_items[i]);
		} else {
			/* create separator */
			separator = gtk_menu_item_new();
			gtk_menu_append(GTK_MENU(file_menu), separator);
			gtk_widget_show(separator);
		}
	}

	file_item = gtk_menu_item_new_with_label("File");
	gtk_widget_show(file_item);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(file_item), file_menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), file_item);

}

/*
 * creates the edit menu in GtkWidget *menu_bar
 *
 */

__inline void create_edit_menu()
{
	GtkWidget *edit_menu;
	GtkWidget *edit_item;
	int i;

	/* create menu the hard way.. */
	edit_menu = gtk_menu_new();

	for (i = 0; i < number_of_edit_menu_items; i++) {
		if (g_strcasecmp(edit_menu_items[i], "-") != 0) {
			menu_items = gtk_menu_item_new_with_label(edit_menu_items[i]);
			gtk_menu_append(GTK_MENU(edit_menu), menu_items);
			gtk_widget_show(menu_items);
			gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate", GTK_SIGNAL_FUNC(edit_menu_response), (gpointer) edit_menu_items[i]);
		} else {
			/* create separator */
			separator = gtk_menu_item_new();
			gtk_menu_append(GTK_MENU(edit_menu), separator);
			gtk_widget_show(separator);
		}
	}

	edit_item = gtk_menu_item_new_with_label("Edit");
	gtk_widget_show(edit_item);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(edit_item), edit_menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), edit_item);
}

/*
 * creates the settings menu in GtkWidget *menu_bar
 */

__inline void create_settings_menu()
{
	GtkWidget *settings_menu;
	GtkWidget *settings_item;
	int i;

	/* create menu the hard way.. */
	settings_menu = gtk_menu_new();

	for (i = 0; i < number_of_settings_menu_items; i++) {
		if ((settings_menu_items[i])[0] != (gchar) "-") {
			menu_items = gtk_menu_item_new_with_label(settings_menu_items[i]);
			gtk_menu_append(GTK_MENU(settings_menu), menu_items);
			gtk_widget_show(menu_items);
			gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate", GTK_SIGNAL_FUNC(settings_menu_response), (gpointer) settings_menu_items[i]);
		} else {
			/* create separator */
			separator = gtk_menu_item_new();
			gtk_menu_append(GTK_MENU(settings_menu), separator);
			gtk_widget_show(separator);
		}
	}

	settings_item = gtk_menu_item_new_with_label("Settings");
	gtk_widget_show(settings_item);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(settings_item), settings_menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), settings_item);
}


/*
 * creates the bookmarks menu in GtkWidget *menu_bar
 * this menu is global, it is also re-created in
 * bookmarks.c when a new bookmark is added
 *
 */

__inline void create_bookmarks_menu()
{

	/* create menu the hard way.. */
	bookmarks_menu = gtk_menu_new();


	bookmarks_item = gtk_menu_item_new_with_label("Bookmarks");
	gtk_widget_show(bookmarks_item);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(bookmarks_item), bookmarks_menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), bookmarks_item);
}

/*
 * creates the help menu in GtkWidget *menu_bar
 *
 */

__inline void create_help_menu()
{
	GtkWidget *help_menu;
	GtkWidget *help_item;

	/* create menu the hard way.. */
	help_menu = gtk_menu_new();

	menu_items = gtk_menu_item_new_with_label("About");
	gtk_menu_append(GTK_MENU(help_menu), menu_items);
	gtk_widget_show(menu_items);
	gtk_signal_connect_object(GTK_OBJECT(menu_items), "activate", GTK_SIGNAL_FUNC(help_menu_response), (gpointer) "About");

	help_item = gtk_menu_item_new_with_label("Help");

	/* help menu is right justified */
	gtk_menu_item_right_justify(GTK_MENU_ITEM(help_item));

	gtk_widget_show(help_item);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(help_item), help_menu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), help_item);
}
