/*******************************************************************************
 *
 * progress.c
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#include <stdarg.h>
#include <stdio.h>

#include "progress.h"
#include "spinner.h"

/*
 * progress_timeout() - updates the progress bar
 */

gboolean progress_timeout(gpointer data)
{
	int val;	

	val = gtk_progress_get_value(GTK_PROGRESS(data));

	if(++val >= 100)
		val = 0;

   	gtk_progress_set_value(GTK_PROGRESS(data), val);

	return TRUE;
}

void progress_start(CheetahWindow *cw)
{
	if(!cw) return;

	gtk_progress_set_activity_mode(GTK_PROGRESS(cw->progress), TRUE);

	cheetah_window_set_cursor(cw, GDK_WATCH);

	cw->spinner_timer = gtk_timeout_add(70, update_spinner, (gpointer)cw);
	cw->progress_timer = gtk_timeout_add(25, progress_timeout, (gpointer)cw->progress);
}

void progress_stop(CheetahWindow *cw)
{
	if(!cw) return;

	gtk_progress_set_activity_mode(GTK_PROGRESS(cw->progress), FALSE);
	gtk_progress_set_value(GTK_PROGRESS(cw->progress), 0);
			
	gtk_timeout_remove(cw->progress_timer);
	gtk_timeout_remove(cw->spinner_timer);

	reset_spinner(cw->spinner);

	cheetah_window_set_cursor(cw, GDK_LEFT_PTR);
}

/*
 * status_print() - prints a message on the statusbar
 */

void status_print(CheetahWindow *cw, const char *format, ...)
{
	char string[512];
	va_list args;
	int id;

	if(!cw) return;
	
	va_start(args, format);
	vsnprintf(string, 511, format, args);
	string[511] = 0;
	va_end(args);
	
	id = gtk_statusbar_get_context_id(GTK_STATUSBAR(cw->status_bar), "text");
	gtk_statusbar_pop(GTK_STATUSBAR(cw->status_bar), id);
	gtk_statusbar_push(GTK_STATUSBAR(cw->status_bar), id, string);
}

