/*******************************************************************************
 *
 * spinner.c - The spinner box.
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Felipe Bergo
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#include "spinner.h"
#include "spinner_icons.h"

void cheetah_load_spinner_xpms(GtkWidget *window);

static int have_spinner = 0;
static GdkPixmap *spin[4];
static GdkBitmap *spinmask[4];

/*
 * create_spinner() - create the spinner
 */

GtkWidget *create_spinner(CheetahWindow *cw, GtkWidget *box)
{
	GtkWidget *spinner;
	GtkWidget *spinner_button;

	/* Load pixmaps */

	cheetah_load_spinner_xpms(cw->window);

	/* Create the button */

	spinner_button = gtk_button_new();
	gtk_button_set_relief(GTK_BUTTON(spinner_button), GTK_RELIEF_NONE);

	gtk_box_pack_end(GTK_BOX(box), spinner_button, FALSE, FALSE, 4);

	gtk_signal_connect(GTK_OBJECT(spinner_button), "clicked", 
					GTK_SIGNAL_FUNC(load_cheetah_page), cw);

	gtk_widget_show(spinner_button);

	/* Then the spinner */

	spinner = gtk_pixmap_new(spin[0], spinmask[0]);
	gtk_container_add(GTK_CONTAINER(spinner_button), spinner);

	gtk_widget_show(spinner_button);
	gtk_widget_show(spinner);

	return spinner;
}

/*
 * cheetah_spinner() - updates the spinner
 */

gboolean update_spinner(gpointer data)
{
	static int i = 0;
	CheetahWindow *cw;
	
	cw = (CheetahWindow *)data;
	gtk_pixmap_set(GTK_PIXMAP(cw->spinner), spin[i + 1], spinmask[i + 1]);
	gtk_widget_queue_resize(cw->spinner);
	
	i = (++i) % 3;
	
	return TRUE;
}

/*
 * cheetah_load_spinner_xpms() - load the pixmaps for the spinner
 */

void cheetah_load_spinner_xpms(GtkWidget *window) 
{
	if(have_spinner)
		return;
	
  	spin[0] = gdk_pixmap_create_from_xpm_d(window->window, &spinmask[0], 
					 &window->style->white, spin0_xpm); 
	spin[1] = gdk_pixmap_create_from_xpm_d(window->window, &spinmask[1], 
					 &window->style->white, spin1_xpm); 
  	spin[2] = gdk_pixmap_create_from_xpm_d(window->window, &spinmask[2], 
					 &window->style->white, spin2_xpm);
  	spin[3] = gdk_pixmap_create_from_xpm_d(window->window, &spinmask[3], 
					 &window->style->white, spin3_xpm);
	
  	have_spinner = 1;
}

void reset_spinner(GtkWidget *spinner)
{
	if(!spinner)
		return;

	gtk_pixmap_set(GTK_PIXMAP(spinner), spin[0], spinmask[0]);
}
