/*******************************************************************************
 *
 * str_util.c - various utility functions for strings.
 *
 * Version info etc.
 * 
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "str_util.h"
#include "debug.h"

__inline int my_toupper(int c) 
{
	if(c >= 'a' && c <= 'z')
		return c - 32;

	return c;
}

__inline int my_tolower(int c)
{
	if(c >= 'A' && c <= 'Z')
		return c + 32;

	return c;
}

__inline int my_strcasecmp(const char *s1, const char *s2) 
{
	while(*s1 && *s2)
		if(my_toupper(*s1++) != my_toupper(*s2++))
			return -1;

	return 0;
}

/*
 * my_strcmp() - faster than libc strcmp(). Used in
 * hash table lookups.
 */

__inline int my_strcmp(const char *s1, const char *s2) 
{
	if(!s1 || !s2)
		return -1;

	while(*s1 && *s2) {

		if(*s1 != *s2)
			return -1;

		++s1; ++s2;
	}

	return 0;
}

__inline char *str_to_lower(const char *str)
{
	char *result, *p;

	result = (char *)malloc(sizeof(char) * strlen(str) + 1);
	if(!result) 
		return NULL;

	p = result;

	while(*str) {
		*p = my_tolower(*str);
		++p; ++str;
	}
	*p = 0;

	return result;
}

__inline char *str_to_upper(const char *str)
{
	char *result, *p;

	result = (char *)malloc(sizeof(char) * strlen(str) + 1);
	if(!result) 
		return NULL;

	p = result;

	while(*str) {
		*p = my_toupper(*str);
		++p; ++str;
	}
	*p = 0;

	return result;

}
