/*******************************************************************************
 *
 * uri.h 
 *
 * Data structure and routines for parsing and storing uri strings. 
 *
 * Cheetah Web Browser
 * Copyright (C) 2001 Garett Spencley
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 *
 *******************************************************************************/

#ifndef __URI_H__
#define __URI_H__

#define SUPPORTED_PROTOCOLS 5

typedef enum {
	HTTP, HTTPS, FTP, GOPHER, L_FILE
} proto_tag;

typedef struct {
	char *string;
	proto_tag id;
} protocol_t;

typedef struct {
	char *host;
	char *abs_path;
	char *anchor;
	unsigned short port;
	unsigned int protocol;
} uri_t;

uri_t *parse_uri(const char *uri);
char *resolve_relative_uri(const char *base, const char *uri);
void uri_free(uri_t *uri);

#endif
