/*
 * color_hash.c - This utility puts all the color hex values in quotation
 * marks for colors.c
 */

#include <stdio.h>

int main(int argc, char **argv)
{
	int c, count;
	char hex[8];
	FILE *f;
	int i;

	if(argc < 2) {
		fprintf(stderr, "Usage: %s input file\n", argv[0]);
		return -1;
	}

	f = fopen(argv[1], "r");
	if(!f) {
		perror(argv[1]);
		return -1;
	}

	count = 0;

	while((c = fgetc(f)) != EOF) {

		if(c == '"') {
			if(count) {

				fputc(c, stdout);

				/* skip over ',' and space */
				fgetc(f);
				fgetc(f);

				hex[0] = '"';

				for(i = 1; i <= 6; i++) 
					hex[i] = fgetc(f);

				hex[i] = '"';
				hex[i+1] = 0;
				
				printf(", %s", hex);

				count = 0;
				continue;
			} else
				++count;
		} 

		fputc(c, stdout);
	}

	fclose(f);

	return 0;
}
