/* 
 * This utility will add a ", NULL" to a hash table (generated
 * by gperf) to facilitate creating new large tables for htmltokenizer.c
 * that requires a 3rd pointer param. 
 */

#include <stdio.h>

int main(int argc, char **argv)
{
	FILE *infile;
	int c;

	if(argc < 2) {
		fprintf(stderr, "Usage: %s <filename>\n", argv[0]);
		return -1;
	}

	infile = fopen(argv[1], "r");
	if(!infile) {
		perror(argv[1]);
		return -1;
	}

	while((c = fgetc(infile)) != EOF) {

		if(c == '}') 
			printf(", NULL");

		fputc(c, stdout);
	}

	fclose(infile);

	return 0;
}
