#~ /***************************************************************************
 #~ *            CPConstants.py
 #~ *
 #~ *  Mon Feb 23 11:21:36 2004
 #~ *  Copyright  2004  Stas Z
 #~ *  stasz@linux.isbeter.nl
 #~ ****************************************************************************/

## CPConstants
## This file provides constants used by all the childsplay modules.

## The module "BASEPATH" is created by the installation proces.

import os,sys
        
## paths ##
import BASEPATH

BASEDIR = BASEPATH.CPDIR
DATADIR = BASEPATH.SHAREDATADIR
MODULESDATADIR = BASEPATH.SHARELIBDATADIR
LOCALEDIR = BASEPATH.LOCALEDIR
ASSETMLROOT = BASEPATH.ASSETMLDIR
SCOREFILE = BASEPATH.SCOREFILE
CHILDSPLAYRC = BASEPATH.CHILDSPLAYRC
LIBDIR = BASEPATH.LIBDIR
MODULES = BASEPATH.MODULESDIR

RCDIR = BASEPATH.RCDIR

HOME_DIR_NAME = BASEPATH.HOME_DIR_NAME

# Check if there's a childsplay dir in the home directory
HOMEDIR = os.path.join(os.environ['HOME'],HOME_DIR_NAME)

# this is the directory tree in HOME_DIR_NAME.
# Names seperated by commas are the names from which directories are created
# if a name are followed by a ; then the next name is considered a sub dir.
# Example: 'childsplay,memory;my_images', will become
# $HOME/.childsplay/childsplay/
# $HOME/.childsplay/memory/my_images/
HOME_DIR_TREE = 'childsplay,ConfigData,memory;my_images'


##  flags ##
MONITOR = None # Special monitor plugin, optional, future use
RCFILES = None # Can we use configuration files
SPLASH = True # do we want a splash  
helptext = "Not much help here yet, look at the manpage and docs."
