/*****************************************************************************
 *
 *       ImmModule.h  ====    Defination of Method Modules Interface 
 *
 ***************************************************************************/
#ifndef __IMMMODULE_H__
#define __IMMMODULE_H__

#include <stdlib.h>
#include <Phrase.h>
#include <ImmDefs.h>

typedef struct  __IMM_CLIENT__
{
    /* ClientData for recording states */
    void *pImmClientData;

    /* Buffer for the PhraseItem */
    PhraseItem m;
    char buf[512];

} IMM_CLIENT;

struct ImmOperation
{
    char     *name;
    char     *version;
    char     *comments;
    u_long   type;               /* eg. IMM_BIG5 << 24 | IMM_CCE */

    /* File I/O Operation */
    IMM_CLIENT *(*open) (char *szFileName, long type);
    int (*save)  (IMM_CLIENT *p, char *szFileName);
    int (*close) (IMM_CLIENT *p);

    /* Indepent Modules support */
    int (*KeyFilter) (IMM_CLIENT *p, u_char key, char *buf, int *len);
    int (*ResetInput) (IMM_CLIENT *p);

    /* Input Area Configuration & Operation */
    int (*ConfigInputArea) (IMM_CLIENT *pImm, int SelectionLen);
    int (*GetInputDisplay) (IMM_CLIENT *pImm, char *buf, long buflen);
    int (*GetSelectDisplay) (IMM_CLIENT *pImm, char *buf, long buflen);
    
    /* Phrase Operation */
    PhraseItem * (*pGetItem) (IMM_CLIENT *p, u_long n);
    int    (*AddPhrase) (IMM_CLIENT *pClient, PhraseItem *p);
    int    (*ModifyPhraseItem) (IMM_CLIENT *p, long n, PhraseItem *pItem);
    int    (*Flush) (IMM_CLIENT *p);
};

#endif

