/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#include "defs.h"
#include "hzclient.h"

//extern Atom hz_cprotocol_atom;
extern Atom hz_config_atom;
Atom hz_protocol_atom;

extern Display *gdk_display;

static void config_inputbar(Window win, int flag, int n1, int n2, int n3);


void config_input(int flag_input)
{
	Window twin;
        hz_protocol_atom = XInternAtom(gdk_display, HZ_PROTOCOL_ATOM,False);
       	twin = XGetSelectionOwner(gdk_display,hz_protocol_atom);
       	if(twin == None) return;
       	config_inputbar(twin, HZCLIENT_CONFIG_INMETHOD,
               	flag_input, 0, 0);
}

void config_corner(int flag_corner)
{
        Window twin;
        hz_protocol_atom = XInternAtom(gdk_display, HZ_PROTOCOL_ATOM,False);
        twin = XGetSelectionOwner(gdk_display,hz_protocol_atom);
        if(twin == None) return;
        config_inputbar(twin, HZCLIENT_CONFIG_QJ,
                flag_corner, 0, 0);
}

void config_punct(int flag_punct)
{
        Window twin;
        hz_protocol_atom = XInternAtom(gdk_display, HZ_PROTOCOL_ATOM,False);
        twin = XGetSelectionOwner(gdk_display,hz_protocol_atom);
        if(twin == None) return;
        config_inputbar(twin, HZCLIENT_CONFIG_PUNCT,
                flag_punct, 0, 0);
}

void config_lock(int flag_lock)
{
        Window twin;
        hz_protocol_atom = XInternAtom(gdk_display, HZ_PROTOCOL_ATOM,False);
        twin = XGetSelectionOwner(gdk_display,hz_protocol_atom);
        if(twin == None) return;
        config_inputbar(twin, HZCLIENT_CONFIG_LOCK,
                flag_lock, 0, 0);
}

static void config_inputbar(Window twin, int flag, int n1, int n2, int n3)
{
        XClientMessageEvent event;

        event.type = ClientMessage;
        event.window = 0;
        event.message_type=hz_config_atom;
        event.format=32;
        event.data.l[0] = flag;
        event.data.l[1] = n1;
        event.data.l[2] = n2;
        event.data.l[3] = n3;
        XSendEvent(gdk_display, twin, True, 0, (XEvent *)&event);
}
